<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <!-- Main content -->
    <div class="content-header">
    </div>
    <!-- /.content-header -->

    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-md-10">
                                <h3>List Invoice Items</h3>
                            </div>
                            <div class="col-md-2 float-right text-right">
                                <a class="btn btn-sm btn-info" href="javascript:void(0);" onclick="addModal()">Add
                                    New</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover" style="width:100%;">
                            <thead>
                                <tr>
                                    <th>Item</th>
                                    <th>Quantity</th>
                                    <th>Price</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="itemListBody">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- Add Modal -->
        <div class="modal" id="itemModal">
            <div class="modal-dialog modal-md">
                <div class="modal-content">

                    <!-- Modal Header -->
                    <div class="modal-header">
                        <h4 class="modal-title">Add Invoice Item</h4>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>

                    <!-- Modal body -->
                    <form class="mt-4" id="addInvoiceItemForm">
                        <div class="modal-body">
                            <?php echo csrf_field(); ?>
                            <div class="row form-group">
                                <div class="col-4">
                                    <label for="item_id">Item Name: <span class="text-danger">*</span></label>
                                </div>
                                <div class="col-8">
                                    <input type="text" name="item" id="item" class="form-control" required>
                                </div>
                            </div>
                            
                            <div class="row form-group">
                                <div class="col-4">
                                    <label for="name">Default Qty: <span class="text-danger">*</span></label>
                                </div>
                                <div class="col-8">
                                    <input type="number" step="1" min="0" name="quantity" id="quantity" class="form-control" required>
                                </div>
                            </div>
                            <div class='invoiceitems'>
                                <div class="row form-group default_quantity">
                                    <div class="col-4">
                                        <label for="fixed_price">Price:</label>
                                    </div>
                                    <div class="col-8">
                                        <input type="number" step="0.01" min="0" name="fixed_price" class="form-control">
                                    </div>
                                </div>

                            <div class="row form-group">
                                <div class="col-4">
                                    <label for="description">Description: <span class="text-danger"></span></label>
                                </div>
                                <div class="col-8">
                                    <textarea name="description" id="description" class="form-control"></textarea>
                                </div>
                            </div>
                                
                                <div class="col-lg-3" >
                                        <label></label>
                                        <button class="add_inv_item btn btn-primary" href="javascript:void(0)" style="display:none;margin-top:30px;" >Add
                                            Price</button>
                                    </div>                                
                                <div class="row itemdetail add_invoice_item one" style="display:none">
                                    <div class="col-lg-3">
                                        <label for="from_quantity">From Quantity: <span class="text-danger">*</span></label>
                                        <input type="number" step="1" min="0" name="from_quantity[]" class="form-control from_qty">
                                    </div>
                                    <div class="col-lg-3">
                                        <label for="to_quantity">To Quantity: <span class="text-danger">*</span></label>
                                        <input type="number" step="1" min="0" name="to_quantity[]" class="form-control to_qty">
                                        <span class="error_msg text-danger" style="display: none"></span>
                                    </div>

                                    <div class="col-lg-2">
                                        <label for="price_id">Price:</label>
                                        <input type="number" step="0.01" min="0" name="price[]" class="form-control">
                                    </div>
                                </div>
                            </div>
                            
                            
                            
                            
                            
                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button class="btn btn-primary btn_submit col-md-3" type="submit" id="btn_submit"><span
                                    class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>&nbsp;Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Edit Modal -->
        <div class="modal fade" id="editInvoiceItemModal">
            <div class="modal-dialog modal-md">
                <div class="modal-content">
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <h4 class="modal-title">Edit Invoice Item</h4>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <!-- Modal body -->
                    <form class="mt-4" id="editInvoiceItemDetailForm">
                        <div class="modal-body">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id" id="edit_item_id" value="">
                            <div class="row form-group">
                                <div class="col-4">
                                    <label for="item_id">Item Name: <span class="text-danger">*</span></label>
                                </div>
                                <div class="col-8">
                                    <input type="text" name="item" id="item" class="form-control" required>
                                </div>
                            </div>
                            
                            <div class="row form-group">
                                <div class="col-4">
                                    <label for="name">Default Qty: <span class="text-danger">*</span></label>
                                </div>
                                <div class="col-8">
                                    <input type="number" step="1" min="0" name="quantity" id="quantity" class="form-control"
                                        required>
                                </div>
                            </div>
                            <div class=' first_edit'>
                                <div class="row form-group default_quantity">
                                    <div class="col-4">
                                        <label for="fixed_price">Price:</label>
                                    </div>
                                    <div class="col-8">
                                        <input type="number" step="0.01" min="0" name="fixed_price" class="form-control">
                                    </div>
                                </div>

                                <div class="row form-group">
                                <div class="col-4">
                                    <label for="description">Description: <span class="text-danger"></span></label>
                                </div>
                                <div class="col-8">
                                    <textarea name="description" id="description" class="form-control"></textarea>
                                </div>
                            </div>
                                
                                <div class="row itemdetail add_invoice_item two" style="display:none">

                                    <div class="col-lg-3">
                                        <label></label>
                                        <button class="add_inv_item btn btn-primary" href="javascript:void(0)" style="margin-top:30px;">Add
                                            Price</button>
                                    </div>
                                </div>
                            </div>
                            <div id="priceeditdetails"></div>
                            
                            
                            
                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button class="btn btn-primary btn_submit col-md-3" type="submit"><span class="spinner-border spinner-border-sm"
                                    role="status" aria-hidden="true"></span>&nbsp;Update</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </section>

    <!-- /.content -->
    <!-- Script Files -->
    <?php echo $__env->make('layouts.scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        var modal = "";
        var site_url = $("#site_url").val() + "/";
        var token = $('meta[name=csrf-token]').attr('content');

        var invoice_item_id = $('#invoice_item_id').val();

        var invoice_item_list = [];

        Object.size = function(obj) {
            var size = 0,
                key;
            for (key in obj) {
                if (obj.hasOwnProperty(key)) size++;
            }
            return size;
        };

        get_Invitem_list();

        function addModal() {
            // get_item_detail(temp_id);
            $('#itemModal').modal('show');
            modal = '#itemModal';
        }

        function get_Invitem_list() {
            $.ajax({
                type: 'GET',
                url: site_url + 'invoice-items/list',
                success: function(data) {
                    invoice_item_list = data;
                    //console.log(data);
                    // Get the size of an object
                    var size = Object.size(data);
                    var html = '';
                    if (size > 0) {
                        var i;
                        for (i = 0; i < size; i++) {
                            html +=
                                `<tr>
                                    <td>${data[i].item}</td>
                                    <td>${data[i].quantity}</td>
                                    <td>${(data[i].price > 0) ? data[i].price.toFixed(2) : '-'}</td>
                                    <td style="white-space: nowrap;"><button class="btn btn-primary btn-sm mr-3" onclick='edit_invoice_item(${data[i].id})'>Edit</button><button class="btn btn-danger btn-sm" onclick="delete_InvItem(${ data[i].id })">Delete</button></td>
                                </tr>`;
                        }

                    } else {
                        html += '<tr><td colspan="8" class="text-center">No Record Found</td></tr>';
                    }

                    $('#itemListBody').html(html);
                },
            });
        }

        function edit_invoice_item(id) {
            $('#priceeditdetails').html('');
            var invoice_item = {};
            modal = '#editInvoiceItemModal';

            invoice_item = invoice_item_list.find(function(item) {
                return item.id == id
            })
            $("#editInvoiceItemDetailForm .first_edit input").val("");
            $("#editInvoiceItemDetailForm").find('.add_invoice_item').nextAll().remove();
            $("#editInvoiceItemDetailForm input[name='item']").val(invoice_item.item);
            $("#editInvoiceItemDetailForm input[id='quantity']").val(invoice_item.quantity);
            $("#editInvoiceItemDetailForm textarea#description").val(invoice_item.description);
                $("#editInvoiceItemDetailForm input[name='quantity']").val(invoice_item.quantity);
                $("#editInvoiceItemDetailForm input[name='fixed_price']").val(invoice_item.price.toFixed(2));
            $('#editInvoiceItemModal').modal('show');
            $('#edit_item_id').val(invoice_item.id);
        }

        $('#addInvoiceItemForm').on('submit', function(e) {
            $(".btn_submit .spinner-border").addClass('spinner-show');
            e.preventDefault();
            $.ajax({
                url: site_url + 'invoice-items/save',
                type: "POST",
                data: new FormData(this),
                cache: false,
                contentType: false,
                processData: false,
                success: function(result) {
                    if (result.status == 200) {
                        $('#addInvoiceItemForm').trigger("reset");
                        get_Invitem_list();
                        $(modal + " .default_quantity").show();
                        $(modal + " .default_quantity input").prop("required", true);
                        $(modal + " .add_invoice_item").hide();
                        $(modal + " .add_invoice_item input").prop("required", false);
                        $('#itemModal').modal('hide');
                        modal = '';
                    }
                    $(".btn_submit .spinner-border").removeClass('spinner-show');
                }
            });
        });

        $('#editInvoiceItemDetailForm').on('submit', function(e) {
            $(".btn_submit .spinner-border").addClass('spinner-show');
            e.preventDefault();
            $.ajax({
                url: site_url + 'invoice-items/update',
                type: "POST",
                data: new FormData(this),
                cache: false,
                contentType: false,
                processData: false,
                success: function(result) {
                    if (result.status == 200) {
                        $('#editInvoiceItemModal').modal('hide');
                        get_Invitem_list();
                        $('#priceeditdetails').html('');
                        modal = '';
                    }
                    $(".btn_submit .spinner-border").removeClass('spinner-show');
                }
            });
        });

        //delete Inv Item 
        function delete_InvItem(id) {
            bootbox.confirm("IMPORTANT! This item is also deleted from the products section. If you have customized this item under products, you will need to re-do the customization. Continue with delete?", function(result) {
                if (result == true) {
                    $.ajax({
                        type: 'POST',
                        url: 'invoice-items/delete',
                        data: "id=" + id + "&_token=" + $('meta[name=csrf-token]').attr('content'),
                        dataType: 'json',
                        success: function(data) {
                            get_Invitem_list();
                        }
                    })
                }
            });
        }

        $('.type').on('change', function() {
            var selected_value = $(this).find(":selected").val();
            if (selected_value == 'Fixed') {
                $(modal + " .default_quantity").show();
                $(modal + " .default_quantity input").prop("required", true);
                $(modal + " .add_invoice_item").hide();
                $(modal + " .add_inv_item").hide();
                $(modal + " .add_invoice_item input").prop("required", false);
            } else if (selected_value == 'Tierd') {
                $(modal + " .default_quantity").hide();
                $(modal + " .default_quantity input").prop("required", false);
                if (modal == '#editInvoiceItemModal') {
                    $(modal + ".add_invoice_item input").prop("required", false);
                } else {
                    $(modal + " .add_invoice_item input").prop("required", true);
                }
                $(modal + " .add_invoice_item").show();
                $(modal + " .add_inv_item").show();
            }
        });
        $(document).on('click', '.remove', function(e) {
            if (modal == '#editInvoiceItemModal' && $(this).parent().parent().parent().parent().attr('id') ==
                'priceeditdetails') {
                $(this).parent().parent().parent().hide();
                $($(this).parent().parent().find('.remove_id')[0]).val(1);
            } else {
                $(this).parent().parent().parent().remove();
            }
        });
        //reapeater form of Invoice items 
        $('.add_inv_item').on('click', function() {
            var itemdetail = `<div class="itemdetail add_invoice_item four"><div class="form-group row">
                <div class="col-sm-3"><label >From Quantity</label> <input type="number" name="from_quantity[]" value="" step="1" min="0" class="form-control from_qty" required></div>
                <div class="col-sm-3"><label >To Quantity</label> <input type="number" name="to_quantity[]" value="" step="1" min="0" class="form-control to_qty" required>
                <span class="error_msg text-danger" style="display: none"></span></div>
                <div class="col-sm-2"><label>Price</label> <input type="number" name="price[]" value="" step="0.01" min="0" class="form-control price" required></div>
                <div class="col-sm-2">
                <a class="remove btn btn-danger" href="javascript:void(0)" style="margin-top:30px;position: absolute;">X</a>
                </div></div></div>`;

            if($('#editInvoiceItemDetailForm').is(':visible')){
                $("#editInvoiceItemDetailForm .invoiceitems").append(itemdetail);
            }
            else{
                $("#addInvoiceItemForm .invoiceitems").append(itemdetail);
            }
        });


        $(document).on("keyup", ".from_qty", function() {
            var from_quantity = parseInt($(this).val());
            var to_qty = $(this).parent().siblings().find('.to_qty').val();
            var current_msg = $(this).parents('.add_invoice_item').find('.error_msg');
            //  console.log(from_quantity,to_qty);
            if (from_quantity > to_qty) {
                current_msg.css("display", "block");
                current_msg.text("Invalid quantity range.");
                $('.btn_submit').prop('disabled', true);

            } else {
                current_msg.text("");
                current_msg.css("display", "none");
                var msg_arr = [];
                $(".error_msg").each(function(index) {
                    msg_arr.push($(this).text());
                });

                if (jQuery.inArray("Invalid quantity range.", msg_arr) >= 0) {

                    $('.btn_submit').prop('disabled', true);
                } else {
                    $('.btn_submit').prop('disabled', false);
                }
            }
        })


        $(document).on("keyup", ".to_qty", function() {
            var to_qty = $(this).val();
            var from_quantity = parseInt($(this).parent().siblings().find('.from_qty').val());
            var current_msg = $(this).parents('.add_invoice_item').find('.error_msg');
            console.log(from_quantity, to_qty);
            if (from_quantity > to_qty) {
                current_msg.css("display", "block");
                current_msg.text("Invalid quantity range.");
                $('.btn_submit').prop('disabled', true);
            } else {
                current_msg.text("");
                current_msg.css("display", "none");
                var msg_arr = [];
                $(".error_msg").each(function(index) {
                    msg_arr.push($(this).text());
                });
                if (jQuery.inArray("Invalid quantity range.", msg_arr) >= 0) {

                    $('.btn_submit').prop('disabled', true);
                } else {
                    $('.btn_submit').prop('disabled', false);
                }
            }

        })

        $('.btn_submit').click(function(e) {
            var qty_arr = [];
            var current_form = $(this).parents('form');
            current_form.find('.to_qty').each(function() {
                if ($(this).val() != "") {
                    qty_arr.push(parseInt($(this).val()));
                }
            });
            var max_qty = Math.max.apply(null, qty_arr);
            var type = current_form.find('.type').find(":selected").val();
            if (type == 'Tierd') {
                var default_qty = current_form.find('#quantity').val();
                if ((max_qty != "")) {
                    if ((default_qty == "")) {
                        current_form.find('#quantity').val(max_qty);
                        e.preventDefault();
                    }
                }

            }


        })

        // auto select show start date and end date on required checkbox

        $(document).on('change', '#is_require_start_date_calendar', function() {
            if (this.checked) {
                $('#is_show_start_date_calendar').prop('checked', true);
            } 
        });
        $(document).on('change', '#is_require_end_date_calendar', function() {
            if (this.checked) {
                $('#is_show_end_date_calendar').prop('checked', true);
            }
        });

        $(document).on('change', '#is_require_start_date_calendar_edit', function() {
            if (this.checked) {
                $('#is_show_start_date_calendar_edit').prop('checked', true);
            } 
        });
        $(document).on('change', '#is_require_end_date_calendar_edit', function() {
            if (this.checked) {
                $('#is_show_end_date_calendar_edit').prop('checked', true);
            }
        });

    </script>

    <!-- End Scripts -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user_layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH G:\xamppLatest\htdocs\quickbook\resources\views/invoice-items/index.blade.php ENDPATH**/ ?>