<!DOCTYPE html>
<!--
This is a starter template page. Use this page to start your new project from
scratch. This page gets rid of all links and provides the needed markup only.
-->
<?php
get_page_name();
if(auth()->user()->role=='1'){
  $report_url = 'reports/transaction-report';
  $home_url = 'invoices';
} else if(auth()->user()->role=='2'){
  $report_url = 'reports/transaction-report';
  $home_url   = 'reports/transaction-report';
} else if(auth()->user()->role=='3'){
  $report_url = 'reports/merchant-report';
  $home_url = 'reports/merchant-report';
} else if(auth()->user()->role=='4'){
  $report_url = 'reports/agent-report';
  $home_url = 'reports/agent-report';
} else {
  $home_url = 'invoices';
  $report_url = 'reports/transaction-report';
}
// echo '<pre>';
// print_r(Session::get('permissions'));exit;
?>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <title><?php echo e(get_settings('site_title')); ?> | <?php echo e(@$page_title); ?></title>
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="<?php echo e(asset("adminlte/plugins/fontawesome-free/css/all.min.css")); ?>">
  <!-- Theme style -->
  <!-- DataTables -->
  <link rel="stylesheet" href="<?php echo e(asset("adminlte/plugins/datatables-bs4/css/dataTables.bootstrap4.css")); ?>">
  <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.3/css/responsive.dataTables.min.css">
  <link rel="stylesheet" href="<?php echo e(asset("adminlte/dist/css/adminlte.min.css")); ?>">
  <!-- daterange picker -->
  <link rel="stylesheet" href="<?php echo e(asset("adminlte/plugins/daterangepicker/daterangepicker.css")); ?>">

  <!-- SweetAlert2 -->
  <link rel="stylesheet" href="<?php echo e(asset("adminlte/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css")); ?>">
  <!-- Toastr -->
  <link rel="stylesheet" href="<?php echo e(asset("adminlte/plugins/toastr/toastr.min.css")); ?>">

  <!-- Bootstrap Multiselect Box-->
  <link href="<?php echo e(asset("assets/css/bootstrap-multiselect.css")); ?>" rel="stylesheet">


  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="<?php echo e(asset("adminlte/plugins/icheck-bootstrap/icheck-bootstrap.min.css")); ?>">


  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="<?php echo e(asset("assets/css/custom.css")); ?>">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <!-- bootstrap slider -->
  <link rel="stylesheet" href="<?php echo e(asset("adminlte/plugins/bootstrap-slider/css/bootstrap-slider.min.css")); ?>">

</head>
<body class="hold-transition layout-top-nav layout-navbar-fixed layout-footer-fixed">
  <input type="hidden" id="site_url" name="site_url" value="<?php echo e(URL::to('/')); ?>">
<div class="wrapper">

  <!-- Navbar -->
  <style>
  #navbarCollapse .navbar-right {
      margin: 0;
      width: 70%;
  float: right !important;
  }
  .navbar-nav > li > .dropdown-menu {
      margin-top: 0;
      border-top-left-radius: 0;
      border-top-right-radius: 0;
  }
  .navbar-right .dropdown-menu {
      right: 0;
      left: auto;
  }
  #navbarCollapse .navbar-right li {
      position: relative;
  }
  #navbarCollapse .dropdown-menu li a {
      width: 100%;
      padding: 12px 20px;
  }
  #navbarCollapse .dropdown-menu li:hover{
    background-color: #D9DEE4;
  }
  .dropdown-menu > li > a {
      color:
      #5A738E;
  }
  .dropdown-menu > li > a {
      display: block;
      padding: 3px 20px;
      clear: both;
      font-weight: 400;
      line-height: 1.42857143;
      color: #333;
      white-space: nowrap;
  }
  .dropdown-menu a, .voiceBtn {
      cursor: pointer;
  }
  .multiselect-container > li > a > label.radio, .multiselect-container > li > a > label.checkbox{
    padding-left: 0px !important;
  }

  .leftnav-menu > .dropdown.show > ul {min-width: 11px;}
.leftnav-menu > .dropdown.show > ul .nav-item{position: relative;}
.leftnav-menu > .dropdown.show > ul .nav-item:hover ul{display: block; left: 100%; top: -10px;}

.hasChild:after {
    display: inline-block;
    margin-left: 0.255em;
    vertical-align: 0.255em;
    content: "";
    border-top: 0.3em solid;
    border-right: 0.3em solid transparent;
    border-bottom: 0;
    border-left: 0.3em solid transparent;
    float: right;
    margin-top: 10px;
    transform: rotate(270deg);
}

  </style>
  <nav class="main-header navbar navbar-expand-md navbar-dark navbar-white">
    <div class="container-fluid">
      <a href="<?php echo e(url($home_url)); ?>" class="navbar-brand">
        <span class="brand-text font-weight-light">
          <h4><img style="height:50px" src="<?php echo e(asset("assets/images/New Project.png")); ?>"></h4>          
        </span>
      </a>
    <ul class="navbar-nav leftnav-menu">
      <li class="nav-item">
        <a href="<?php echo e(url($home_url)); ?>" class="nav-link">Home</a>
      </li>
      <?php if(in_array('users',Session::get('permissions')) || in_array('merchants',Session::get('permissions')) || in_array('agents',Session::get('permissions'))): ?>
        <li class="nav-item dropdown" style="display:none;">
          <a id="dropdownSubMenu3" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="nav-link dropdown-toggle">Users</a>
          <ul aria-labelledby="dropdownSubMenu3" class="dropdown-menu border-0 shadow">
            <?php if(in_array('users',Session::get('permissions'))): ?>
              <li><a href="<?php echo e(url('users')); ?>" class="dropdown-item">List Users</a></li>
              <li><a href="<?php echo e(url('users/form')); ?>" class="dropdown-item">Add New </a></li>
            <?php endif; ?>
            <?php if(in_array('roles',Session::get('permissions'))): ?>
            <!-- <li><a href="<?php echo e(url('roles')); ?>" class="dropdown-item">Roles</a></li> -->
            <?php endif; ?>
          </ul>
        </li>
        <?php endif; ?>
                 
      <li class="nav-item dropdown">
        <a id="dropdownSubMenu2" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="nav-link dropdown-toggle">Accounting</a>
        <ul aria-labelledby="dropdownSubMenu2" class="dropdown-menu border-0 shadow">          
          <li class="nav-item">
            <a href="<?php echo e(url('/invoices')); ?>" class="nav-link">Invoices</a>
          </li>
          <?php if(in_array('invoice-items',Session::get('permissions'))): ?>
           <li class="nav-item">
            <a href="<?php echo e(url('/invoice-items')); ?>" class="nav-link">Invoice Items</a>
          </li>
          <?php endif; ?>
          
        </ul>
      </li>
  </ul>
      <button class="navbar-toggler order-1" type="button" data-toggle="collapse" data-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse order-3" id="navbarCollapse">
        <!-- Left navbar links -->
        <ul class="navbar-nav">

          <li class="nav-item move-leftnav">
            <a href="<?php echo e(url($home_url)); ?>" class="nav-link">Home</a>
          </li>
          <?php if(in_array('users',Session::get('permissions')) || in_array('merchants',Session::get('permissions')) || in_array('agents',Session::get('permissions'))): ?>
            <li class="nav-item dropdown move-leftnav">
              <a id="dropdownSubMenu3" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="nav-link dropdown-toggle">View</a>
              <ul aria-labelledby="dropdownSubMenu3" class="dropdown-menu border-0 shadow">
                <?php if(in_array('users',Session::get('permissions'))): ?>
                  <li><a href="<?php echo e(url('users')); ?>" class="dropdown-item">Users </a></li>
                <?php endif; ?>
                <?php if(in_array('merchants',Session::get('permissions'))): ?>
                <li><a href="<?php echo e(url('merchants')); ?>" class="dropdown-item">Merchants</a></li>
                <?php endif; ?>
                <?php if(in_array('agents',Session::get('permissions'))): ?>
                <li><a href="<?php echo e(url('agents')); ?>" class="dropdown-item">Agents</a></li>
                <?php endif; ?>
                <?php if(in_array('roles',Session::get('permissions'))): ?>
                <li><a href="<?php echo e(url('roles')); ?>" class="dropdown-item">Roles</a></li>
                <?php endif; ?>
              </ul>
            </li>
            <?php if(in_array('users/form',Session::get('permissions')) || in_array('merchants/form',Session::get('permissions')) || in_array('agents/form',Session::get('permissions'))): ?>
                <li class="nav-item dropdown move-leftnav">
                  <a id="dropdownSubMenu1" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="nav-link dropdown-toggle">Add New</a>
                  <ul aria-labelledby="dropdownSubMenu1" class="dropdown-menu border-0 shadow">
                    <?php if(in_array('users/form',Session::get('permissions'))): ?>
                    <li><a href="<?php echo e(url('users/form')); ?>" class="dropdown-item">Users </a></li>
                    <?php endif; ?>
                    <?php if(in_array('merchants/form',Session::get('permissions'))): ?>
                    <li><a href="<?php echo e(url('merchants/form')); ?>" class="dropdown-item">Merchants</a></li>
                    <?php endif; ?>
                    <?php if(in_array('agents/form',Session::get('permissions'))): ?>
                    <li><a href="<?php echo e(url('agents/form')); ?>" class="dropdown-item">Agents</a></li>
                    <?php endif; ?>
                    <?php if(in_array('agents/form',Session::get('permissions'))): ?>
                    <li><a href="<?php echo e(url('agents/form?type=subajent')); ?>" class="dropdown-item">Add Sub-Agent</a></li>
                    <?php endif; ?>
                    <?php if(in_array('roles/form',Session::get('permissions'))): ?>
                    <li><a href="<?php echo e(url('roles/form')); ?>" class="dropdown-item">Add Role</a></li>
                    <?php endif; ?>
                  </ul>
                </li>
            <?php endif; ?>
          <?php endif; ?>
          <li class="nav-item dropdown move-leftnav">
            <a id="dropdownSubMenu2" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="nav-link dropdown-toggle">CB Reports</a>
            <ul aria-labelledby="dropdownSubMenu2" class="dropdown-menu border-0 shadow">
              <li><a href="<?php echo e(url($report_url)); ?>" class="dropdown-item">Transaction Reports </a></li>
            </ul>
          </li>        

          <li class="nav-item dropdown">
            <a id="dropdownSubMenu1" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="nav-link dropdown-toggle">Settings</a>
            <ul aria-labelledby="dropdownSubMenu1" class="dropdown-menu border-0 shadow">
              <li><a href="<?php echo e(url('users/profile')); ?>" class="dropdown-item">Profile </a></li>
              <?php if(in_array('settings',Session::get('permissions'))): ?>
              <!-- <li><a href="<?php echo e(url('banks')); ?>" class="dropdown-item">Banks </a></li> -->
              <li><a href="<?php echo e(url('settings')); ?>" class="dropdown-item">More Settings</a></li>
              <?php endif; ?>
            </ul>
          </li>
          <li class="nav-item">
            <a href="<?php echo e(url('logout')); ?>" class="nav-link">
              <i class="fas far fa-sign-out-alt"></i>Logout
            </a>
          </li>
        </ul>
      </div>
    </div>
  </nav>  <!-- /.navbar -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Main content -->
    <div class="content">
      <div class="container-fluid">
        <?php echo $__env->yieldContent('content'); ?>
      </div>
      <!-- /.container-fluid -->
      <div class="modal" id="accounting_schedule_newfield" data-keyboard="false" data-backdrop="static" role="dialog">
        <form id="sch_newfield_form" name="sch_newfield_form" method="post">          
            <div class="modal-dialog modal-lg ui-draggable ui-draggable-handle">
              <div class="modal-content">
                  <div class="modal-header">
                    <h4 class="modal-title">Create Field</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">×</span>
                    </button>
                  </div>
      
                  <div class="modal-body">
      
                    <div class="row">
                      <div class="col-md-12">
      
                      <div class="form-group">
                         <label for="sch_fieldname">Field Name</label>
                         <input type="text" value="" class="form-control" name="sch_fieldname" id="sch_fieldname">
                      </div>
                      <div class="form-group">
                        <label for="sch_fieldname_repeat">Confirm Field Name</label>
                        <input type="text" value="" class="form-control" name="sch_fieldname_repeat" id="sch_fieldname_repeat">
                     </div>
                     <div class="form-group">
                      <label class="control-label col-sm-3" for="sch_fieldsource">Fee Source:</label>
                      <div class="col-sm-6">
                      <select class="form-control" name="sch_fieldsource" id="sch_fieldsource">
                      <option value="PayArc_Statement">PayArc_Statement</option>
                      <option value="Residual_Report">Residual_Report</option>
                      <option value="pay_flow_crm">PayFlow CRM</option>
                      </select>                                                              
                      </div>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-12">
                      Note: After a field is created, you must contact dev team for it to be fully activated. You cannot delete a field. It must be deleted by dev.
                    </div>
                  </div>      
                  </div>
                  <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>  
                    <button class="btn btn-primary col-md-3" type="button" id="accounting_schedule_newfield_save_btn"><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>&nbsp;Save</button>
                    </div>
              </div>
            </div>
         </form>
      </div>
    </div>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->


  <!-- Main Footer -->
  <footer class="main-footer">
    <!-- To the right -->
    <div class="float-right d-none d-sm-inline" style="display:none !important;">
      Call US: 2424124
    </div>
    <!-- Default to the left -->
    <strong>Copyright &copy; 2024-<?php echo(date('Y')); ?> <a href="#">A+O Invoicing</a>.</strong> All rights reserved.
  </footer>
</div>
<!-- ./wrapper -->

<!-- REQUIRED SCRIPTS -->

</body>
</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/quickbook/resources/views/user_layout.blade.php ENDPATH**/ ?>