<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title><?php echo e(get_settings('site_title')); ?> | Log in</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo e(asset("adminlte/plugins/fontawesome-free/css/all.min.css")); ?>">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="<?php echo e(asset("adminlte/plugins/icheck-bootstrap/icheck-bootstrap.min.css")); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(asset("adminlte/dist/css/adminlte.min.css")); ?>">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <style>
  .login-page, .register-page {
      background-repeat: round;
      background-color: #1C6FBA;
  }
  .login-box, .register-box {
        box-shadow: 0 0 1px
      rgba(0,0,0,.125),0 1px 3px
      rgba(0,0,0,.2);
      width: auto !important;
      margin: 2%;
      background:#fff;padding-top: 1rem;
  }
  </style>
</head>
<body class="hold-transition login-page">
<div class="login-box">
  <div class="login-logo">
    <a href="javascript:void(0)"><img style="width:90%" src="<?php echo e(asset("assets/images/PayFlowCRMLogoWhite.png")); ?>"></a>
  </div>
  <!-- /.login-logo -->
  <div class="card">
    <div class="card-body login-card-body">
      <p class="login-box-msg">Sign in to start your session</p>

      <form method="POST" action="<?php echo e(route('login2')); ?>">
        <?php echo csrf_field(); ?>
        <div class="input-group mb-3">
          <input id="email" placeholder="Email Address/MerchantId" class="form-control" type="text" name="email" value="" autofocus>
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-envelope"></span>
            </div>
          </div>
        </div>
        <div class="input-group mb-3">
          <input id="password" type="password" placeholder="Password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" required autocomplete="current-password">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-lock"></span>
            </div>
          </div>
<?php $__errorArgs = ['error'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
              <span class="invalid-feedback" role="alert" style="display:block !important;">
                  <strong><?php echo e($message); ?></strong>
              </span>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        <div class="row">
          <div class="col-8">
            <div class="icheck-primary">
              <input class="form-check-input" type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
              <label for="remember">
                Remember Me
              </label>
            </div>
          </div>
          <!-- /.col -->
          <div class="col-4">
            <button type="submit" class="btn btn-primary btn-block">Sign In</button>
          </div>
          <!-- /.col -->
        </div>
      </form>

      <div class="social-auth-links text-center mb-3" style="display:none;">
        <p>- OR -</p>
        <a href="#" class="btn btn-block btn-primary">
          <i class="fab fa-facebook mr-2"></i> Sign in using Facebook
        </a>
        <a href="#" class="btn btn-block btn-danger">
          <i class="fab fa-google-plus mr-2"></i> Sign in using Google+
        </a>
      </div>
      <!-- /.social-auth-links -->

      <p class="mb-1">
        <a href="<?php echo e(route('reset-password')); ?>">I forgot my password</a>
      </p>
      <p class="mb-0" style="display:none;">
        <a href="<?php echo e(route('register')); ?>" class="text-center">Register a new membership</a>
      </p>
      <div class="text-center"><img src="<?php echo e(asset('assets/images/encryption.png')); ?>" width="170"></div>

    </div>
    <!-- /.login-card-body -->
  </div>
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="<?php echo e(asset("adminlte/plugins/jquery/jquery.min.js")); ?>"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo e(asset("adminlte/plugins/bootstrap/js/bootstrap.bundle.min.js")); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(asset("adminlte/dist/js/adminlte.min.js")); ?>"></script>

</body>
</html>
<?php /**PATH G:\xamppLatest\htdocs\ebstream\resources\views/auth/login.blade.php ENDPATH**/ ?>