<?php
use App\Http\Middleware\CheckPermission;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\{RoleController, AgentController, ReportController, CronController, BulkSmsController, UserController, SettingsController, ProductsController, SchedulesController, InvoiceItemController,HomeController,DashboardController,AccountingTemplateController,MerchantController,AchController,CardController,InvoiceController,InvoicePublicController,CardProviderController,BankController};
use App\Http\Controllers\QuickBooksController;

Route::get('/quickbooks/connect', [QuickBooksController::class, 'connect']);
Route::get('/quickbooks/callback', [QuickBooksController::class, 'callback']);
Route::post('/quickbooks/create-invoice', [QuickBooksController::class, 'createInvoice']);
Route::get('/quickbooks/upload-pdf', [QuickBooksController::class, 'uploadPdf']);
Route::post('/quickbooks/syncCustomers', [QuickBooksController::class, 'syncCustomers']);
Route::get('/quickbooks/updateInvoice', [QuickBooksController::class, 'updateInvoice']);
Route::get('/quickbooks/invoicePayment', [QuickBooksController::class, 'invoicePayment']);

Route::get('/quickbooks/connect', [QuickBooksController::class, 'connect'])
     ->name('quickbooks.connect');
// Step 2: Intuit will redirect back here
Route::get('/quickbooks/callback', [QuickBooksController::class, 'callback'])
     ->name('quickbooks.callback');

// Step 3: After successful auth you land here
Route::get('/quickbooks/dashboard', [QuickBooksController::class, 'dashboard'])
     ->name('quickbooks.dashboard');


Route::get('/', function () {
    return view('welcome');
});
//https://appcenter.intuit.com/app/connect/oauth2/error?client_id=ABzqxCxTiMVwSEcKSfOhRc3W1dd5jZdKk9s9KF142zN2CGGTIF&scope=com.intuit.quickbooks.accounting&redirect_uri=http%3A%2F%2Flocalhost%3A8000%2Fcallback&response_type=code&state=DVPCW&locale=en-gb

Route::get('/page_403', [UserController::class, 'page_403']);

// 404 Page Route
Route::get('/page_404', function () {
    $page_title = "Page not found";
    return view('page_404', compact('page_title'));
});

// Authentication Routes
Auth::routes();

// Home Route
Route::get('/', [HomeController::class, 'home']);

// Dashboard Route
Route::get('dashboard', [DashboardController::class, 'index']);


Route::post('login2', [LoginController::class, 'login2'])->name('login2');

// Password Reset Routes
Route::get('reset-password/', [ForgotPasswordController::class, 'reset_password_form'])->name('reset-password');
Route::get('reset-password/{token}', [ForgotPasswordController::class, 'reset_password_form']);
Route::post('reset_password', [ForgotPasswordController::class, 'reset_password']);
Route::post('generate_password', [ForgotPasswordController::class, 'generate_password']);
Route::get('reset', [ForgotPasswordController::class, 'reset'])->name('reset');

// Logout Route
Route::get('/logout', [UserController::class, 'logout']);



// Invoice Routes
Route::prefix('invoices')->group(function () {
    Route::get('/{id?}', [InvoiceController::class, 'index']);
    Route::post('/createinvoicepromo/{id?}', [InvoiceController::class, 'create_invoice_promo']);
    Route::get('/history/{id}', [InvoiceController::class, 'invoice_history']);
    Route::post('/ajax_grid_data', [InvoiceController::class, 'ajax_grid_data']);
    Route::post('/save_invoice', [InvoiceController::class, 'ajax_save_invoice']);
    Route::post('/createinvoice', [InvoiceController::class, 'createinvoice']);
    Route::get('/form', [InvoiceController::class, 'form']);
    Route::get('/invoicedetail/{id}', [InvoiceController::class, 'invoicedetail']);
    Route::post('/save', [InvoiceController::class, 'save']);
    Route::post('/getinvoice', [InvoiceController::class, 'getinvoice']);
    Route::post('/merchantinvoice', [InvoiceController::class, 'merchantinvoice']);
    Route::post('/delete', [InvoiceController::class, 'delete']);
    Route::post('/invoice_payments', [InvoiceController::class, 'invoice_payments']);
    Route::post('/invoice_payments_history', [InvoiceController::class, 'invoice_payments_history']);

    
    Route::post('/minvoice_payments', [InvoiceController::class, 'minvoice_payments']);
    Route::post('/payinvoiceach', [InvoiceController::class, 'payinvoiceach']);
    Route::post('/add_invoice_payment', [InvoiceController::class, 'add_invoice_payment']);
    Route::post('/add_minvoice_payment', [InvoiceController::class, 'add_minvoice_payment']);
    Route::post('/remove_invoice_payment', [InvoiceController::class, 'remove_invoice_payment']);
    Route::post('/getaddress', [InvoiceController::class, 'getaddress']);
    Route::post('/invoice_email', [InvoiceController::class, 'invoice_email']);
    Route::post('/send_email', [InvoiceController::class, 'send_email']);
    Route::get('/paypublic/{id}', [InvoicePublicController::class, 'payinvoice']);
    Route::post('/public/pay_with_achmodal', [InvoicePublicController::class, 'pay_with_achmodal']);
});

// Role Routes
Route::prefix('roles')->controller(RoleController::class)->group(function () {
    Route::get('/', 'index');
    Route::post('/ajax_grid_data', 'ajax_grid_data');
    Route::get('/form', 'form');
    Route::post('/save', 'save');
    Route::post('/delete', 'delete');
});


Route::middleware([\App\Http\Middleware\CheckPermission::class])->group(function () {
    // User Routes
    Route::prefix('users')->controller(UserController::class)->group(function () {
        Route::get('/', 'index');
        Route::post('/ajax_grid_data', 'ajax_grid_data');
        Route::get('/form', 'form');
        Route::post('/save', 'save');
        Route::get('/view', 'form');
        Route::post('/delete', 'delete');
        Route::get('/profile', 'profile');
        Route::post('/update_profile', 'update_profile');
        Route::post('/change_password_dialog', 'change_password_dialog');
        Route::post('/change_password', 'change_password');
    });


    // Customers Routes
    Route::prefix('customers')->controller(AgentController::class)->group(function () {
        Route::get('/', 'index');
        Route::post('/ajax_grid_data', 'ajax_grid_data');
        Route::get('/form', 'form');
        Route::get('/view', 'form');
        Route::post('/save', 'save');
        Route::post('/delete', 'delete');
        Route::get('/assign_agent', 'assign_agent');
        Route::post('/save_assign_agents', 'save_assign_agents');
        Route::get('/ignore_downloaded_merchants', 'ignore_downloaded_merchants');
    });
});

// Settings Routes
Route::controller(SettingsController::class)->group(function () {
    Route::post('/savesheet', 'savesheet');
    Route::get('settings', 'index');
    Route::post('updatemerchant', 'updateMerchant');
    Route::post('save_settings', 'save_settings');
});

// Invoice Item Routes
Route::prefix('invoice-items')->controller(InvoiceItemController::class)->group(function () {
    Route::get('/', 'index');
    Route::get('/list', 'get_list');
    Route::post('/save', 'save');
    Route::post('/update', 'update');
    Route::post('/delete', 'delete');
    Route::get('/view', 'getInvitemDetails');
});