@extends('index')

@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
  <div class="container-fluid">
    <nav class="navbar navbar-expand navbar-white navbar-light">
      <div class="card-header">
        <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{url('users/')}}">Users</a></li>
              <li class="breadcrumb-item active">{{$popup_title}}</li>
            </ol>
      </div>

      <!-- Right navbar links -->
      <ul class="navbar-nav ml-auto">
        <li class="nav-item">
          <a class="nav-link" data-widget="pushmenu" href="#"><i class="fas fa-bars"></i></a>
        </li>
      </ul>
    </nav>
  </div><!-- /.container-fluid -->
</section>

<!-- Main content -->

<section class="content">
  <div class="container-fluid">
    <div class="row">
      <!-- left column -->
      <div class="col-md-12">
        <!-- jquery validation -->
        <div class="card card-primary">
          <div class="card-header">
            <h3 class="card-title">{{$popup_title}}</h3>
          </div>
          <!-- /.card-header -->
          <!-- form start -->
          <form role="form" id="user_form" name="user_form" method="post">
            <input type="hidden" name="id" id="id" value="{{$row->id}}">
            <div class="card-body">



              <form id="add_new_setting_form" autocomplete="off" name="add_new_setting_form" method="post" class="form-horizontal form-label-left" enctype="multipart/form-data">
              <div id="myTabContent" class="tab-content">

                <div role="tabpanel" class="tab-pane fade" id="payment_settings" aria-labelledby="home-tab">
                  <div class="form-group">
                        <label class="col-md-12 col-sm-12 col-xs-12 text-left">Commission Type</label>
                        <div class="col-md-12 col-sm-12 col-xs-12">
                          <select class="form-control" name="settings[commission_type]" id="commission_type">
                            <option value="fixed" <?php if($settings_array['commission_type']=='fixed'){ echo 'selected=selected'; }?>>Fixed</option>
                            <option value="percentage" <?php if($settings_array['commission_type']=='percentage'){ echo 'selected=selected'; }?>>Percentage</option>
                          </select>
                        </div>
                  </div>

                  <div class="form-group">
                          <label class="col-md-12 col-sm-12 col-xs-12 text-left">Commission Amount</label>
                          <div class="col-md-12 col-sm-12 col-xs-12">
                            <input class="form-control" name="settings[commission_amount]" id="commission_amount" value="{{@$settings_array['commission_amount']}}">
                          </div>
                  </div>



                  <div class="form-group">
                        <label class="col-md-12 col-sm-12 col-xs-12 text-left">Paypal Seller Email</label>
                        <div class="col-md-12 col-sm-12 col-xs-12">
                          <input class="form-control" name="settings[seller_email]" id="seller_email" value="{{@$settings_array['seller_email']}}">
                        </div>
                  </div>

                </div>

                <div role="tabpanel" class="tab-pane fade in active" id="site_settings" aria-labelledby="home-tab">
                            <input type="hidden" name="id" value="">
                        <div class="modal-body">
                          <div class="row">
                            <div class="col-md-6 col-sm-6 col-xs-12 ">
                              <div class="form-group">
                                      <label class="col-md-12 col-sm-12 col-xs-12 text-left">Email</label>
                                      <div class="col-md-12 col-sm-12 col-xs-12">
                                     <input class="form-control" name="email" id="email" value="{{@Auth::user()->email}}">
                                      </div>
                              </div>

                              <div class="form-group">
                                      <label class="col-md-12 col-sm-12 col-xs-12 text-left">Password </label>
                                      <div class="col-md-12 col-sm-12 col-xs-12">
                                        <input type="password" autocomplete="false" readonly onfocus="this.removeAttribute('readonly');" class="form-control" name="password" id="password" value="">
                                      </div>
                              </div>

                              <div class="form-group">
                                      <label class="col-md-12 col-sm-12 col-xs-12 text-left">Confirm Password </label>
                                      <div class="col-md-12 col-sm-12 col-xs-12">
                                        <input type="password" class="form-control" name="confirm_password" id="confirm_password" value="">
                                      </div>
                              </div>



                            </div>

                            <div class="col-md-6 col-sm-6 col-xs-12 ">
                            <div class="form-group">
                                    <label class="col-md-12 col-sm-12 col-xs-12 text-left">Site Title</label>
                                    <div class="col-md-12 col-sm-12 col-xs-12">
                                      <input class="form-control" name="settings[site_title]" id="site_title" value="{{@$settings_array['site_title']}}">
                                    </div>
                            </div>


                            </div>



                          </div>
                      </div>

                </div>
              </div>
              </form>



            </div>
            <!-- /.card-body -->
            <div class="card-footer">
              <button type="button" class="btn btn-primary" id="save-user">Save</button>
            </div>
          </form>
        </div>
        <!-- /.card -->
        </div>
      <!--/.col (left) -->
      <!-- right column -->
      <div class="col-md-6">

      </div>
      <!--/.col (right) -->
    </div>
    <!-- /.row -->
  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
<!-- Script Files -->
@include('layouts.scripts')
<!-- End Scripts -->
@endsection
