<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>{{get_settings('site_title')}} | Log in</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="{{ asset("adminlte/plugins/fontawesome-free/css/all.min.css")}}">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="{{ asset("adminlte/plugins/icheck-bootstrap/icheck-bootstrap.min.css")}}">
  <!-- Theme style -->
  <link rel="stylesheet" href="{{ asset("adminlte/dist/css/adminlte.min.css")}}">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <style>
  .login-page, .register-page {
      background-repeat: round;
      background-color: #1C6FBA;
  }
  .login-box, .register-box {
        box-shadow: 0 0 1px
      rgba(0,0,0,.125),0 1px 3px
      rgba(0,0,0,.2);
      width: auto !important;
      margin: 2%;
      background:#fff;padding-top: 1rem;
  }
  </style>
</head>
<body class="hold-transition login-page">
<div class="login-box">
  <div class="login-logo">
    <a href="//payflowcrm.com"><img style="width:60%" src="{{ asset("assets/images/rsz_cb_002.png") }}"></a>
  </div>
  <!-- /.login-logo -->
  <div class="card">
    <div class="card-body login-card-body">
    @if (Session::has('public_pay_error'))
        <div class="alert alert-danger">{{ Session::get('public_pay_error') }}</div>    
    @else
        <div class="row">
        <div class="col-8">
<h4>Invoice Number: {{$invoicenum ?? 00000}} </h4>
        </div> 
        <div class="col-4">&nbsp;</div>
    </div>
    <div class="row">
        <div class="col-8">
            <h3>Balance Due: ${{number_format($balance,2)}}</h3></p>
        </div>
        <div class="col-4">&nbsp;</div>
    </div>

      <form method="POST">
        <div class="row">
          <div class="col-4">            
                <button type="button" id="public_downloadinvoice" data-publicpayid="{{$publicpayid}}" class="btn btn-primary btn-block"><span class="fas fa-download"></span>&nbsp;View Invoice (PDF)</button>            
          </div>
          <!-- /.col -->
          <div class="col-8">
            <button type="button" id="public_payinvoice"  data-toggle="modal" data-target="#invoice_payments_ach_public" data-publicpayid="{{$publicpayid}}" class="btn btn-primary btn-block">Pay Now</button>
          </div>
          <!-- /.col -->
        </div>
      </form>
      <div class="row">
        <div class="col-8">
            &nbsp;
        </div>
        <div class="col-4">&nbsp;</div>
    </div> 
    <div class="row">
        <div class="col-8">
            &nbsp;
        </div>
        <div class="col-4">&nbsp;</div>
    </div>   
    @endif
      <div class="row">
        <div class="col-12">
            Copyright (c) {{ date('Y') }}. All rights reserved. Secure payment page for payflowcrm.com 256bit SSL encryption.</p>
        </div>        
    </div>    

    </div>
    <!-- /.login-card-body -->
  </div>
</div>
<!-- /.login-box -->
<div class="modal" id="invoice_payments_ach_public" data-keyboard="false" data-backdrop="static" role="dialog"> </div>
<!-- jQuery -->
<script src="{{ asset("adminlte/plugins/jquery/jquery.min.js")}}"></script>
<!-- Bootstrap 4 -->
<script src="{{ asset("adminlte/plugins/bootstrap/js/bootstrap.bundle.min.js")}}"></script>
<!-- AdminLTE App -->
<script src="{{ asset("adminlte/dist/js/adminlte.min.js")}}"></script>
<script>
    var site_url = "{{url('/')}}/";
    var token = "{{ csrf_token() }}";
$(document).ready(function(){

    $("#invoice_payments_ach_public").on("show.bs.modal", function (event) {   
    var button = $(event.relatedTarget);
    var publicpayid = button.data("publicpayid");    
    
    $.ajax({
      type: "POST",
      url: site_url + "invoices/public/pay_with_achmodal",
      dataType: "json",
      data: { _token: token, publicpayid: publicpayid },
      success: function (data) {
        if (data.status == 1) {
          //hide #invoice_payments_ach modal          
          $("#invoice_payments_ach_public").html(data.html);

          //$("#invoice_payments_ach_public .modal-dialog").draggable();
        } else
        {
          alert("Error while retrieving ACH data. Your payment link might no longer be valid. Please try again");
          //hide #invoice_payments_ach modal
            $("#invoice_payments_ach_public").modal("hide");
        }
       
      },
      error: function (data) {        
        alert("error");
      },
    });
  });

});
</script>
</body>
</html>
