<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Invoice {{$invoice['invoice_id']}}</title>
  <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: "Times New Roman", Times, serif;
      padding: 20px;
      font-size: 1.1rem;
      position: relative;
      min-height: 100vh;
      background-color: #fff;
      line-height: 1.5;
    }

    .container {
      margin: 0 auto;
      padding-left: 30px;
      padding-right: 30px;
      padding-bottom: 40px;
    }

    .logo {
      font-size: 1.8rem;
      font-weight: 900;
      font-family: Georgia, "Times New Roman", Times, serif;
      text-align: center;
      margin-bottom: 0.5rem;
    }

    .logo .plus {
      color: #c63452;
    }

    .invoice-title {
      font-size: 1.4rem;
      font-weight: bold;
      margin-top: 5px;
      margin-bottom: 10px;
    }

    .section-title {
      font-weight: bold;
      margin-top: 15px;
      margin-bottom: 5px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }

    table td {
      vertical-align: top;
      padding: 6px 0;
    }

    .amount {
      text-align: right;
      white-space: nowrap;
    }

    .fw-bold {
      font-weight: bold;
    }

    .footer {
      position: absolute;
      bottom: 20px;
      width: 100%;
      text-align: center;
      font-size: 0.95rem;
    }

    address,
    p {
      margin-bottom: 8px;
    }

    .mb-1 {
      margin-bottom: 4px;
    }

    .mb-2 {
      margin-bottom: 8px;
    }

    .mt-3 {
      margin-top: 12px;
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="logo">A<span class="plus">+</span>O</div>

    <p class="mt-3 mb-2">{{ date("F j, Y", strtotime($invoice['invoicedate'])) }}
    </p>

    <address class="mb-2">
      <strong>Paal Kibsgaard</strong><br />
      1711 Allen Parkway<br />
      Unit 2106<br />
      Houston, TX 77019
    </address>

    <p class="mb-1">
      <strong>Hermes Birkin Bags</strong><br />
      New York Weekend
    </p>

    <p class="invoice-title">Invoice {{$invoice['invoice_id']}}</p>

    <table>
      <tbody>
      <?php
          $bal = ($invoice['balance'])?$invoice['balance']:0;
          $pbal=($invoice['balance'])?$invoice['balance']:0;
          $ispaid=0;
          if($invoice['amount']!=''){
            $bal = $invoice['amount']-$bal;
            if($bal=="0"){
              $ispaid=1;
            }
          }
      ?>
      @if(!empty($payments))
        @foreach($payments as $payment)
        <?php
          $total=$payment->amount*$payment->quantity;
         // dd($payment);
        ?>
            <tr>
                <td>{{$payment->description}}<br /><small>{{$payment->quantity}}*{{$payment->amount}}</small></td>
                <td class="amount">${{number_format((float)$total, 2, '.', '')}}</td>
            </tr>
        @endforeach
      @endif

     
        <tr class="fw-bold">
          <td>Total</td>
          <td class="amount">USD ${{number_format((float)$invoice['amount'], 2, '.', '')}}</td>
        </tr>
      </tbody>
    </table>

    <p class="section-title">Wire Transfer Information</p>
    <p>
      <strong>A+O Inc.</strong><br />
      SWIFT: CHASUS33<br />
      JPMorgan Chase Bank<br />
      204 West 4th Street<br />
      New York, NY 10014<br />
      USA<br /><br />
      ABA#: 021 000 021<br />
      ACC#: 670 801 906
    </p>

    <p>
      <strong>A+O Inc.</strong><br />
      72 Barrow Street<br />
      Suite 5u<br />
      New York, NY 10014
    </p>
  </div>


</body>
</html>
