@extends('user_layout')
@section('content')
<div class="modal" id="invoice_payments_ach" data-keyboard="false" data-backdrop="static" role="dialog"> </div>
<div class="modal" id="add_achinfo_ps" data-keyboard="false" data-backdrop="static" role="dialog"> </div>

<!-- Content Header (Page header) -->
<!-- Main content -->
<div class="content-header">
</div>
<!-- /.content-header -->

<section class="content">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-10">
                            <h3>List Invoices</h3>
                        </div>
                        <div class="col-md-12 float-right text-right" style="margin-bottom: 10px;">
                            <a id="create_invoice_btn" href="javascript:void(0)" data-toggle="modal" data-target="#create_invoice" class="btn btn-sm btn-info">New</a>
                            @if (auth()->user()->role == 1)
                            <button class="btn btn-sm btn-danger" id="delete-invoice">Delete</button>
                            @endIf
                            @if (auth()->user()->role == 1)
                            <a href="javascript:void(0)" data-toggle="modal" data-target="#minvoice_payments" class="btn btn-sm btn-info">Record
                                Payment</a>
                            @endIf
                            <button class="btn btn-sm btn-info" id="export-quick-book"><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> &nbsp;Export to QBO</button>

                        </div>
                    </div>
                </div>

                <!-- /.card-header -->
                <div class="card-body">
                    <table id="invoicesGrid" class="table table-bordered table-hover" style="width:100%;">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="select-all" name="select-all"></th>
                                <th>Date</th>
                                <th>Number</th>
                                <th>Customer</th>
                                <!-- <th>Status</th> -->
                                <th>Amount Due</th>
                                <th>Paid</th>
                                <th>Balance</th>
                                <th>Exported to QB</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th></th>
                                <th>Date</th>
                                <th>Number</th>
                                <th>Customer</th>
                                <!-- <th>Status</th> -->
                                <th>Amount Due</th>
                                <th>Paid</th>
                                <th>Balance</th>
                                <th>Exported to QB</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->


        </div>
        <!-- /.col -->
    </div>
    <!-- /.row -->

    <div class="modal" id="invoice_payments" style="">
    </div>

    <div class="modal" id="invoice_payments_history" style="z-index: 1100;">
    </div>

    
    <div class="modal" id="invoice_email" data-keyboard="false" data-backdrop="static" role="dialog">
    </div>

    <div class="modal" id="minvoice_payments" style="">
    </div>

    <div class="modal" id="view_invoice" style="z-index: 1060;">
        <form id="invoice_formupdate" name="invoice_form" method="post">
            <div class="modal-dialog modal-xl ui-draggable ui-draggable-handle">
                <div class="modal-content">

                    <div class="modal-header">
                        <h4 class="modal-title">View Invoice</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>

                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4>&nbsp;</h4>
                                <div class="form-group row">
                                    <div class="col-md-3"> <label for="name">Bill To: </label></div>
                                    <div class="col-md-9">
                                        <input type="text" id="merchandid_view" readonly>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="name">Address</label>
                                    <textarea readonly class="form-control" name="address" id="address_view"></textarea>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <h4>&nbsp;</h4>
                              

                        <div class="form-group row">
                            <div class="col-md-6">
                                <label for="name">Invoice Number: </label>
                            </div>
                            <div class="col-md-6">
                                <input type="text" value="#10{{ $invoiceid }}" class="form-control" readonly id="iid_view">
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class="col-md-6">
                                <label for="name">Invoice Date: </label>
                            </div>
                            <div class="col-md-6" style="position: relative;">
                                <input type="text" class="form-control" name="invoicedate" id="invoicedate_view" readonly style="padding-left: 25px;">
                                <i class="fa fa-calendar" aria-hidden="true" style="position:absolute;z-index: 1px;top: 11px;margin-left: 5px;"></i>
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class="col-md-6">
                                <label for="name">Payment Due: </label>
                            </div>
                            <div class="col-md-6" style="position: relative;">
                                <input type="text" class="form-control" name="duedate" id="duedate_view" readonly style="padding-left: 25px;">

                                <i class="fa fa-calendar" aria-hidden="true" style="position:absolute;z-index: 1px;top: 11px;margin-left: 5px;"></i>
                            </div>
                        </div>

                    </div>

                    <div class="col-md-12 invoiceitems_view">
                    </div>

                </div>

                <div class="row">
                    <div class="col-sm-12">
                        <style type="text/css">
                            .trclass {
                                position: relative;
                            }

                            .tdclass {
                                position: absolute;
                                left: 70px;
                            }
                        </style>

                        <table style="float:right;margin-right: 0px;width:150px;">
                            <tr class='trclass' style="display:none">
                                <td>Subtotal: </td>
                                <td id="subtotal_view" class="tdclass">0.00</td>
                            </tr>
                            <tr class='trclass' style="display:none">
                                <td>Tax: </td>
                                <td class="tdclass" id="tax">0.00</td>
                            </tr>
                            <tr class='trclass'>
                                <td>Total: </td>
                                <td id="ftotal_view" class="tdclass">0.00</td>
                            </tr>
                            <tr class='trclass'>
                                <td>Payment: </td>
                                <td id="payment_view" class="tdclass">0.00</td>
                            </tr>
                            <tr class='trclass'>
                                <td>Balance: </td>
                                <td id="balance_view" class="tdclass">0.00</td>
                            </tr>
                        </table>

                    </div>

                </div>

            </div>

            <div class="modal-footer d-flex justify-content-between w-100">
    <div>
        <input type="hidden" id="edit_inv_id">
        <button type="button" class="btn btn-default" id="close_view_invoice_btn" data-dismiss="modal">Close</button>
        @if (auth()->user()->role == 1)
        <a id="invoice_history_btn" href="javascript:void(0)" data-toggle="modal" data-target="#invoice_history" data-dismiss="modal" class="btn btn-default" style="display:none;">Edit History</a>
        @endif
    </div>
    <div>
        

        <button 
    type="button"
    data-id="{{ $invoiceid }}" 
    data-toggle="modal" 
    data-balance="" 
    data-target="#invoice_payments_history" 
    class="btn btn-primary">
    Payments
</button>
        <button class="btn btn-primary" type="button" id="updateinvoice">
            <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>&nbsp;Save
        </button>
        <a class="btn btn-primary" id="printInvoiceBtn" target="_blank" href="invoices/invoicedetail/{{ $invoiceid }}">Print</a>
    </div>
</div>

    </div>
    </div>
    </form>
    </div>

    <div class="modal" id="invoice_history">
        <div class="modal-dialog modal-lg ui-draggable ui-draggable-handle">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Invoice History</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <h5>Showing History of Invoice: #10<span id="invoice_id_history"></span></h5>
                    </div>
                    <div class="invoice_history_table">
                        <table class="table table-bordered table-hover" style="width:100%;">
                            <thead>
                                <tr>
                                    <th>Column</th>
                                    <th>New Value</th>
                                    <th>Old Value</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody id="invoiceHistoryBody">
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal" id="create_invoice">
        <form id="invoice_form" name="invoice_form" method="post">
            <input type="hidden" name="promoinvoice" id="promoinvoice" value>
            <div class="modal-dialog modal-xl ui-draggable ui-draggable-handle">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Create Invoice</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="row">
                            <div class="col-md-6">
                                <h4>&nbsp;</h4>
                                <div class="form-group row">
                                    <div class="col-md-3"> <label for="name">Bill To: </label></div>
                                    <div class="col-md-9">
                                    <div class="d-flex align-items-center">

                                    <select class="form-control me-2" name="merchandid" id="merchandid" style="flex: 1;">
                                    <option value="">Select Customer</option>
            @if (!empty($customers))
                @foreach ($customers as $qb_id=>$customer)
                    <option value="{{$qb_id}}" alt="1">
                        {{ $customer }}
                    </option>
                @endforeach
            @endif
        </select>&nbsp;&nbsp;
        <a href="javascript:void(0)" class="btn btn-primary" id="sync-invoice-customers"><i class="fas fa-sync-alt me-1"></i>&nbsp;Sync</a>

                        </div>

                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="name">Address</label>
                                    <textarea readonly class="form-control" name="address" id="address"></textarea>
                                </div>

                            </div>

                            <div class="col-md-6">

                                <h4>&nbsp;</h4>
                                
                        <div class="form-group row">
                            <div class="col-md-6">
                                <label for="name">Invoice Number: </label>
                            </div>
                            <div class="col-md-6">
                                <input type="text" value="{{ $invoiceid }}" class="form-control" id="iid">
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class="col-md-6">
                                <label for="name">Invoice Date: </label>
                            </div>
                            <div class="col-md-6" style="position: relative;">
                                <input type="text" class="form-control" name="invoicedate" id="invoicedate" readonly style="padding-left: 25px;">
                                <i class="fa fa-calendar" aria-hidden="true" style="position:absolute;z-index: 1px;top: 11px;margin-left: 5px;"></i>
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class="col-md-6">
                                <label for="name">Payment Due: </label>
                            </div>
                            <div class="col-md-6" style="position: relative;">
                                <input type="text" class="form-control" name="duedate" id="duedate" readonly style="padding-left: 25px;">
                                <i class="fa fa-calendar" aria-hidden="true" style="position:absolute;z-index: 1px;top: 11px;margin-left: 5px;"></i>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 invoiceitems">
                        <div class="col-md-12 d-flex  align-items-center justify-content-between border-bottom py-2">

                            <h4 class="m-0 pt-2">Items</h4>
                            <span id="fromqty">&nbsp;</span> <a class="addinvitem btn btn-primary" href="javascript:void(0)">Add item</a>
                        </div>

                        <div class="itemdetail pt-3">
                            <div class="form-group row selectionDiv">
                                <div class="col-sm-3">
                                    <span id="fromqty">Item</span>
                                    <select name="inv_items[]" class="form-control inv_items" id="inv_items">
                                        <option>Select Item</option>
                                        @foreach ($inv_items as $inv_item)
                                        <option value="{{ $inv_item->id }}" class="invItemOption" data-type="{{ $inv_item->type }}" data-qty="{{ $inv_item->quantity }}" data-price="{{ $inv_item->price }}" data-description="{{ $inv_item->item }}" data-prices="{{ json_encode($inv_item->prices) }}" show_start_date="{{ $inv_item->is_show_start_date_calendar }}" show_end_date="{{ $inv_item->is_show_end_date_calendar }}" required_start_date="{{ $inv_item->is_require_start_date_calendar }}" required_end_date="{{ $inv_item->is_require_end_date_calendar }}">
                                            {{ $inv_item->item }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-sm-4 descDiv">
                                    <span id="fromqty">Description</span> <input type="text" name="invdescription[]" value="" class="form-control invdescription" id="invdescription">
                                </div>

                                <div class="col-sm-1 qtyDiv">
                                    <span id="fromqty">Qty</span> <input type="text" name="invqty[]" value="" class="form-control invqty" id="invqty">
                                </div>


                                <div class="col-sm-1 rateDiv">
                                    <span id="fromqty">Price</span> <input type="text" name="invrate[]" value="" class="form-control invrate" id="invrate">
                                </div>

                                <div class="col-sm-2 totalAmountDiv">
                                    <span id="fromqty">Amount</span> <input type="text" name="totAmount[]" value="" class="form-control totAmount" id="totAmount" readonly>
                                </div>



                            </div>

                        </div>
                        


                    </div>

                </div>
                <div class="row">

                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <style type="text/css">
                            .trclass {
                                position: relative;
                            }

                            .tdclass {
                                position: absolute;
                                left: 70px;
                            }
                        </style>

                        <table style="float:right;margin-right: 0px;width:150px;">
                            <tr class='trclass' style="display:none">
                                <td>Subtotal1: </td>
                                <td id="subtotal" class="tdclass">0.00</td>
                            </tr>
                            <tr class='trclass' style="display:none">
                                <td>Tax: </td>
                                <td class="tdclass" id="tax">0.00</td>
                            </tr>
                            <tr class='trclass'>
                                <td>Total: </td>
                                <td id="ftotal" class="tdclass">0.00</td>
                            </tr>
                            <tr class='trclass' style="display:none">
                                <td>Payment: </td>
                                <td class="tdclass">0.00</td>
                            </tr>
                            <tr class='trclass' style="display:none">
                                <td>Balance: </td>
                                <td class="tdclass">0.00</td>
                            </tr>
                        </table>

                    </div>

                    {{-- <div class="col-sm-10" style="text-align: right;">
                                    <span class="subtitle">Subtotal:</span> <span id="subtotal">0.00</span>
                                </div>

                                <div class="col-sm-10" style="text-align: right;">
                                    <span class="subtitle">Tax:</span> 0.00
                                </div>

                                <div class="col-sm-10" style="text-align: right;">
                                    <span class="subtitle">Total:</span> <span id="ftotal">0.00</span>
                                </div>

                                <div class="col-sm-10" style="text-align: right;">
                                    <span class="subtitle">Payment</span>: 0.00
                                </div>

                                <div class="col-sm-10" style="text-align: right;">
                                    <span class="subtitle">Balance:</span> 0.00
                                </div> --}}
                </div>

                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button class="btn btn-primary col-md-3" type="button" id="saveinvoice"><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>&nbsp;Save</button>
                </div>
            </div>
    </div>
    </div>
    </form>
    </div>
</section>
<style type="text/css">
    .ui-autocomplete {
        position: absolute;
        z-index: 9999 !important;
        top: 0;
        left: 0;
        cursor: default;
        background-color: #fff;
        padding: 3px;
        border: 1px solid #ccc
    }

    .ui-autocomplete>li.ui-state-focus {
        background-color: #FF6C00;
    }
</style>
<!-- /.content -->
<!-- Script Files -->
@include('layouts.scripts')
<!-- End Scripts -->
<script>
    function get_invoice_log(invoiceId) {
        $.ajax({
            type: 'GET',
            url: '<?php echo URL::to('/'); ?>/invoices/history/' + invoiceId,
            success: function(data) {
                // console.dir(data);
                var size = data.length;
                var html = '';
                if (size > 0) {
                    var i;
                    for (i = 0; i < size; i++) {
                        var date = data[i].created_at;
                        html +=
                            `<tr>
                                    <td>${data[i].field}</td>
                                    <td>${data[i].new_value}</td>
                                    <td>${data[i].old_value}</td>
                                    <td>${date}</td>                                    
                                </tr>`;
                    }
                    // console.log(html);
                    $('#invoiceHistoryBody').html(html);
                }
            },
        });
    }

    $(document).on('click', '.invoiceitems .addinvitem', function(e) {
        var itemdetail = ``;
        itemdetail += `  <div class="itemdetail">
<div class="form-group row selectionDiv">
  <div class="col-sm-3">
      <span id="fromqty">Item</span> <select name="inv_items[]"  class="form-control inv_items" id="inv_items" >
        <option>Select Item</option>`;
        @foreach($inv_items as $inv_item)
        itemdetail +=
            `<option class="invItemOption" value="{{ $inv_item->id }}" data-description="{{ $inv_item->item }}" data-type="{{ $inv_item->type }}" data-qty="{{ $inv_item->quantity }}" data-price="{{ $inv_item->price }}" data-prices="{{ json_encode($inv_item->prices) }}" show_start_date="{{ $inv_item->is_show_start_date_calendar }}" show_end_date="{{ $inv_item->is_show_end_date_calendar }}" required_start_date="{{ $inv_item->is_require_start_date_calendar }}" required_end_date="{{ $inv_item->is_require_end_date_calendar }}">{{ $inv_item->item }}</option>`;
        @endforeach
        itemdetail += `</select>
  </div>
<div class="col-sm-4 descDiv">
  <span id="fromqty">Description</span> <input type="text" name="invdescription[]" value="" class="form-control invdescription" id="invdescription" >
</div>


<div class="col-sm-1 qtyDiv">
  <span id="fromqty">Qty</span> <input type="text" name="invqty[]" value="" class="form-control invqty" id="invqty">
</div>


<div class="col-sm-1 rateDiv">
  <span id="fromqty">Price</span> <input type="text" name="invrate[]" value="" class="form-control invrate" id="invrate">
</div>

    <div class="col-sm-2 totalAmountDiv">
        <span id="fromqty">Amount</span> <input type="text" name="totAmount[]" value="" class="form-control totAmount" id="totAmount" readonly>
    </div>


<div class="col-sm-1">
  <span id="fromqty">&nbsp;</span> <a class="removeinvitem btn btn-danger" href="javascript:void(0)" style="margin-top:22px;">X</a>
</div>



</div>

                                </div>`;



        $(".invoiceitems").append(itemdetail);

    });

     // Add new items in case of Edit

     $(document).on('click', '.invoiceitems_view .addinvitem', function(e) {
        var itemdetail = ``;
        itemdetail += `  <div class="itemdetail">
<div class="form-group row">
  <div class="col-sm-3">
      <span id="fromqty">Item</span> <select name="inv_items[]"  class="form-control inv_items edit_inv_items" id="inv_items" >
        <option value="">Select Item</option>`;
        @foreach($inv_items as $inv_item)
        itemdetail +=
            `<option class="invItemOption" value="{{ $inv_item->id }}" data-description="{{ $inv_item->item }}" data-type="{{ $inv_item->type }}" data-qty="{{ $inv_item->quantity }}" data-price="{{ $inv_item->price }}" data-prices="{{ json_encode($inv_item->prices) }}" show_start_date="{{ $inv_item->is_show_start_date_calendar }}" show_end_date="{{ $inv_item->is_show_end_date_calendar }}" required_start_date="{{ $inv_item->is_require_start_date_calendar }}" required_end_date="{{ $inv_item->is_require_end_date_calendar }}">{{ $inv_item->item }}</option>`;
        @endforeach
        itemdetail += `</select>
  </div>
<div class="col-sm-4" descDiv>
  <span id="fromqty">Description</span> <input type="text" name="invdescription[]" value="" class="form-control invdescription" id="invdescription" >
</div>

<div class="col-sm-1 qtyDiv">
  <span id="fromqty">Qty</span> <input type="text" name="invqty[]" value="" class="form-control invqty" id="invqty">
</div>

<div class="col-sm-1" rateDiv>
  <span id="fromqty">Rate</span> <input type="text" name="invrate[]" value="" class="form-control invrate" id="invrate">
</div>

    <div class="col-sm-2 totalAmountDiv">
        <span id="fromqty">Amount</span> <input type="text" name="totAmount[]" value="" class="form-control totAmount" id="totAmount" readonly>
    </div>


<div class="col-sm-1">
  <span id="fromqty">&nbsp;</span> <a class="removeinvitem btn btn-danger" href="javascript:void(0)" style="margin-top:22px;">X</a>
</div>



</div>

                                </div>`;
        $(".invoiceitems_view").append(itemdetail);

    });

    // Already Existed Item

    $(document).on('click', '.viewinvoice', function(e) {

        var invoiceid = $(this).attr("alt");
        var token = $('meta[name=csrf-token]').attr('content');
        if (invoiceid != '') {

            $("#buy_week_trend_dialog").modal('hide');

            $('#view_invoice').modal('show');


            var title = $(this).attr("title");


            $.ajax({
                type: 'POST',
                url: '<?php echo URL::to('/'); ?>/invoices/getinvoice',
                data: {
                    _token: token,
                    invoiceid: invoiceid
                },
                success: function(data) {

                    var res = $.parseJSON(data);
                   // console.log(res['data']['invoice']['id']);

                    var inv = res['data']['invoice'];
                    //get address details
                    

                    if (inv) {

                        var items = res['data']['items'];

                        //alert(inv['merchant']);
                        //$("#merchandid_view option:selected").removeAttr("selected");

                        $("#edit_inv_id").val(inv['id']);
                        const printBtn = document.getElementById("printInvoiceBtn");
    printBtn.href = `invoices/invoicedetail/${inv['id']}`;

                        $("#merchandid_view").val(inv['merchant_name']);
                        //$('#merchandid_view option[value='+inv['merchant']+']').attr('selected','selected');
                        //$('#acct_template_view option[value='+inv['acct_template']+']').attr('selected','selected');

                        $("#invoicedate_view").val(inv['invoicedate']);
                        var bal = 0;
                        if (inv['amount'] != '') {
                            bal = inv['amount'] - inv['balance'];
                        }
                        $("#duedate_view").val(inv['duedate']);

                        $("#address_view").html(inv['address'].replace("<br />", ""));

                        $("#subtotal_view").html(inv['amount'].toFixed(2));
                        $("#ftotal_view").html(inv['amount'].toFixed(2));

                        if (inv['balance']) {
                            $("#payment_view").html(inv['balance'].toFixed(2));
                        } else {
                            $("#payment_view").html("0.00");
                        }

                        $("#balance_view").html(bal.toFixed(2));


                        $("#iid_view").val("#" + inv['invoice_id']);

                        var itemhtml = '';
                        if (items.length != 0) {
                            itemhtml =
                                '<div class="col-md-12 d-flex  align-items-center justify-content-between border-bottom py-2"><h4 class="m-0 pt-2">Items</h4><span id="fromqty">&nbsp;</span> <a class="addinvitem btn btn-primary" href="javascript:void(0)">Add item</a></div> ';
                            for (var i = 0; i < items.length; i++) {
                                var amt = 0;
                                if (items[i]['amount']) {
                                    amt = items[i]['amount'];
                                }

                                var qty = 0;
                                if (items[i]['quantity']) {
                                    qty = items[i]['quantity'];
                                }
                                var newAmount = 0;
                                newAmount = qty*amt;

                                var description = '';
                                if (items[i]['description']) {
                                    description = items[i]['description'];
                                }

                                var start_date = '';
                                if (items[i]['start_date']) {
                                    start_date = items[i]['start_date'];
                                }

                                var end_date = '';
                                if (items[i]['end_date']) {
                                    end_date = items[i]['end_date'];
                                }

                                var inv_item_id = '';
                                if (items[i]['inv_item_id']) {
                                    inv_item_id = items[i]['inv_item_id'];
                                }

                                if (description != '') {

                                    var delic = '';

                                    if (title == "update") {

                                        if (i == 0) {

                                            delic = `<div class="col-sm-2">
                         
                        </div>`;

                                        } else {
                                            delic = `<div class="col-sm-1">
                            <span id="fromqty">&nbsp;</span> <a class="removeinvitem btn btn-danger" href="javascript:void(0)" style="margin-top:22px;">X</a>
                          </div>`;
                                        }

                                    }

                                    var showStartDate = false;
                                    var showEndDate = false;
                                    var requireStartDate = '';
                                    var requireEndDate = '';

                                    itemhtml += `<div class="itemdetail">
<div class="form-group row selectionDiv">
  <div class="col-sm-3">
      <span id="fromqty">Item</span> <select name="inv_items[]"  class="form-control inv_items edit_inv_items" id="inv_items" >
        <option>Select Item</option>`;
                                    @foreach($inv_items as $inv_item)
                                    selected = '';
                                    if(parseInt(inv_item_id) == parseInt({{$inv_item->id}})){
                                        selected = 'selected';
                                        if(parseInt({{$inv_item->is_show_start_date_calendar}}) == 1){
                                            showStartDate = true;     
                                        }
                                        if(parseInt({{$inv_item->is_show_end_date_calendar}}) == 1){
                                            showEndDate = true;     
                                        }                                        
                                        if(parseInt({{$inv_item->is_require_start_date_calendar}}) == 1){
                                            requireStartDate = 'required';     
                                        }
                                        if(parseInt({{$inv_item->is_require_end_date_calendar}}) == 1){
                                            requireEndDate = 'required';     
                                        }                                        
                                    }
                                    itemhtml +=
                                        `<option ${selected} class="invItemOption" value="{{ $inv_item->id }}" data-description="{{ $inv_item->item }}" data-type="{{ $inv_item->type }}" data-qty="{{ $inv_item->quantity }}" data-price="{{ $inv_item->price }}" data-prices="{{ json_encode($inv_item->prices) }}" show_start_date="{{ $inv_item->is_show_start_date_calendar }}" show_end_date="{{ $inv_item->is_show_end_date_calendar }}" required_start_date="{{ $inv_item->is_require_start_date_calendar }}" required_end_date="{{ $inv_item->is_require_end_date_calendar }}">{{ $inv_item->item }}</option>`;
                                    @endforeach
                                    itemhtml += `</select>
  </div>
    <div class="col-sm-4 descDiv">
      <span id="fromqty">Description</span> <input type="text" name="invdescription[]" value="${description}" class="form-control invdescription" id="invdescription" >
    </div>
    

    <div class="col-sm-1 qtyDiv">
      <span id="fromqty">Qty</span> <input type="text" name="invqty[]" value="${qty}" class="form-control invqty" id="invqty">
    </div>

    <div class="col-sm-1 rateDiv">
      <span id="fromqty">Rate</span> <input type="text" name="invrate[]" value="${amt}" class="form-control invrate" id="invrate">
    </div>

    <div class="col-sm-2 totalAmountDiv">
        <span id="fromqty">Amount</span> <input type="text" name="totAmount[]" class="form-control totAmount" id="totAmount" value="${newAmount}" readonly="">
    </div>

    ${delic}
    

    </div>

                                    </div>`;
                                }

                            }
                            //alert(itemhtml);

                            $(".invoiceitems_view").html(itemhtml);


                        }

                    }
                    // $("#saveinvoice .spinner-border").removeClass('spinner-show');

                    /*  if(data.status=='succ'){
                        toastr.success(data.msg);
                        $("#create_invoice").modal('hide');

                        setTimeout(function () {
                            location.reload(true);
                          }, 1000);

                      } else {
                        $("#saveinvoice .spinner-border").removeClass('spinner-show');
                        toastr.error(data.msg);
                      }*/

                    $('input.datePicker').datepicker({
                        minDate: '-100y',
                        maxDate: '+1y',
                        dateFormat: "yy-mm-dd",

                    });

                    $(document).on('click', '#invoice_history_btn', function() {
                        $('#invoice_id_history').text(invoiceid);
                        get_invoice_log(invoiceid)
                    })

                },
                error: function(data) {

                }
            });

        }

    });


    // promo create invoice
    @if(isset($promo_form) && $promo_form == true)
    var promo_form = true;
    $("#promoinvoice").val("1");
    var invoice_items_promo = <?php echo json_encode($invoice_items_promo); ?>;
    var desc_promo = <?php echo json_encode($merchantName_promo); ?>;
    var qty_promo = <?php echo json_encode($qty_promo); ?>;
    @else
    var promo_form = false;
    @endif


    if (promo_form) {
        $("#create_invoice_btn").trigger("click");

        for (let i = 1; i < invoice_items_promo.length; i++) {
            $(".addinvitem").trigger("click");
        }       
        console.log(desc_promo);
        $(".inv_items").each(function(index) {
            $(this).find("option:selected").removeAttr("selected");
            $(this).find("option[value='" + invoice_items_promo[index] + "']").prop("selected", true).trigger("change");
            if(desc_promo!= null){
            $(this).parent().siblings('.descDiv').children('.invdescription').val(desc_promo[index]);
            }
            $(this).parent().siblings('.qtyDiv').children('.invqty').val(qty_promo[index]);
            var rate = $(this).find(":selected").attr("data-price");
            $(this).parent().siblings('.rateDiv').children('.invrate').val(rate);
        })
        setTimeout(function() {
            console.log('now');
            $('.invqty').change();
        }, 2000);        

        var total = 0;
        $(".invoiceitems .invqty").each(function() {
            var qtyval = $(this).val();
            var rateval = $(this).parent().next().children(".invrate").val();
            total += qtyval * rateval;
        });
        $("#subtotal").html(total.toFixed(2));
        $("#ftotal").html(total.toFixed(2));

        $('#create_invoice').on('hidden.bs.modal', function () {
            var url = $("#site_url").val() + "/";
            window.location.href = url+"invoices";
        });

    }
</script>
@endsection