@extends('index')

@section('content')
<!-- Content Header (Page header) -->
<style>
.table td, .table th {
    padding: .45rem;
}
</style>
<!-- Content Header (Page header) -->
<section class="content-header">
  <div class="container-fluid">
    <nav class="navbar navbar-expand navbar-white navbar-light">
      <div class="card-header">
        <h3 class="card-title">DataTable with minimal features & hover style</h3>
      </div>

      <!-- Right navbar links -->
      <ul class="navbar-nav ml-auto">
        <li class="nav-item">
          <a class="nav-link" data-widget="pushmenu" href="#"><i class="fas fa-bars"></i></a>
        </li>
      </ul>
    </nav>
  </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <!-- /.card-header -->
        <div class="card-body">
          <table id="example2" class="table table-bordered table-hover">
            <thead>
            <tr>
              <th>Id</th>
              <th>Remember Token</th>
              <th>Name</th>
              <th>Email</th>
            </tr>
            </thead>
            <tbody>
            </tbody>
            <tfoot>
            <tr>
              <th>Id</th>
              <th>Remember Token</th>
              <th>Name</th>
              <th>Email</th>
            </tr>
            </tfoot>
          </table>
        </div>
        <!-- /.card-body -->
      </div>
      <!-- /.card -->


    </div>
    <!-- /.col -->
  </div>
  <!-- /.row -->
</section>
<!-- /.content -->
<!-- Script Files -->
@include('layouts.scripts')
<!-- End Scripts -->
<script>
  $(function () {
    $('#example2').DataTable( {
      "responsive": true,
      "processing": true,
      "orderable": true,
      "serverSide": true,
      "paging": true,
      "pageLength": 10,
      "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
      "ajax": {
        "url": 'ajaxtableList',
      },
      "columns": [
       { "data": "id" },
       {"data":"remember_token"},
       { "data": "name" },
       { "data": "email" }
      ]
    });
  });
</script>
@endsection
