<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>{{get_settings('site_title')}} | Log in</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="{{ asset("adminlte/plugins/fontawesome-free/css/all.min.css")}}">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="{{ asset("adminlte/plugins/icheck-bootstrap/icheck-bootstrap.min.css")}}">
  <!-- Theme style -->
  <link rel="stylesheet" href="{{ asset("adminlte/dist/css/adminlte.min.css")}}">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="{{ asset("assets/css/custom.css") }}">
  <style>
  .login-page, .register-page {
      background-repeat: round;
      background-color: #1C6FBA;
  }
  .login-box, .register-box {
        box-shadow: 0 0 1px
      rgba(0,0,0,.125),0 1px 3px
      rgba(0,0,0,.2);
      width: auto !important;
      margin: 2%;
      background:#fff;padding-top: 1rem;
  }
  </style>
  <!-- SweetAlert2 -->
  <link rel="stylesheet" href="{{ asset("adminlte/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css") }}">
  <!-- Toastr -->
  <link rel="stylesheet" href="{{ asset("adminlte/plugins/toastr/toastr.min.css")}}">
</head>
<body class="hold-transition login-page">

<div class="login-box">
  <div class="login-logo">
    <a href="javascript:void(0)">
    A<font color="red">+</font>O Invoicing
  </a>
  </div>
  <!-- /.login-logo -->
  <div class="card">
    <div class="card-body login-card-body">
      <form role="form" id="reset_password_form" name="reset_password_form" method="post">
      <input type="hidden" id="site_url" name="site_url" value="{{URL::to('/')}}">
      <input type="hidden" name="token_value" id="token_value" value="{{$token}}">
      @if($token_set==1 && $token_count==0)
      <p class="login-box-msg text-danger"><br/><br/>Your token has been expired or not valid.<br/> Click on below button.<br/><br/>
        <div class="form-group row" style="margin-top:5%;">
          <div class="col-md-12 text-center">
            <a class="btn btn-info col-md-12" href="{{ route('reset-password') }}">Reset Password</a>
          </div>
          <div class="col-md-12 text-center" style="margin-top:10px;">
            <a class="btn btn-info col-md-12" href="{{ route('login') }}">Back To Login</a>
          </div>
        </div>
      </p>
      @else
      @if($token_count==0)
      <p class="login-box-msg">Enter your email address below then press reset,<br/> and we will email you a new password link.</p>
      @endIf
        <input type="hidden" name="token_set" id="token_set" value="{{$token_set}}">
        @csrf
        <div class="form-group row">
          <label for="inputEmail" class="col-sm-4 col-form-label">Email</label>
          <div class="col-sm-8">
            <input type="text" class="form-control" name="email" id="email" placeholder="Email Address"  value="{{$email}}">
          </div>
        </div>
        @if($token_set==1 && $token_count>0)
        <div class="form-group row">
          <label for="inputEmail" class="col-sm-4 col-form-label">New Password</label>
          <div class="col-sm-8">
            <input type="password" name="new_password" value="" class="form-control" id="new_password" placeholder="New Password">
          </div>
        </div>

        <div class="form-group row">
          <label for="inputEmail" class="col-md-4 col-form-label">Retype password</label>
          <div class="col-sm-8">
            <input type="password" name="retype_password" value="" class="form-control" id="retype_password" placeholder="Retype Password">
          </div>
        </div>
        @endIf
        <div class="form-group row" style="margin-top:5%;">
          <div class="col-md-12 text-center">
            <button class="btn btn-info col-md-12" type="button" id="reset-password"><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>&nbsp;Reset</button>
          </div>
          <div class="col-md-12 text-center" style="margin-top:10px;">
            <a class="btn btn-info col-md-12" href="{{ route('login') }}">Back To Login</a>
          </div>
        </div>
      @endIf
    </form>
    </div>
    <!-- /.login-card-body -->
  </div>
</div>
<!-- /.login-box -->

@include('layouts.scripts')
</body>
</html>
