class RowEditor {

    constructor(tableId) {
        this.table = tableId;
        this.rowInEditMode = null;
        this.originalRowValues = null;
    }

    deleteRow(indexOfCallingRow) {
        if (this.rowInEditMode) {
            this.resetRow();
        }
        table.row(indexOfCallingRow).remove().draw();
    }

    editTd(this1,id,type,tdvalue='',paymenttype='$',group_id='',scheduletype='') {
        var v1=$(this1).html();

        if(type=="1"){
            $(this1).html(this.getInputHTML_b("input",v1,id,group_id,scheduletype));    
        }else if(type=="9"){
            $(this1).html(this.getInputHTML_b("checkbox",tdvalue,id,group_id,scheduletype));    
        }else if(type=="10"){
            $(this1).html(this.getInputHTML_b("checkbox1",tdvalue,id,group_id,scheduletype));    
        }else if(type=="2"){

            $(this1).html(this.getInputHTML_b("input_dropdown",tdvalue,id,group_id,scheduletype));    
            $('#type option[value="'+paymenttype+'"]').prop('selected', true);
            
        }else if(type=="11"){

            $(this1).html(this.getInputHTML_b("input_dropdown_11",tdvalue,id,group_id,scheduletype));    
            $('#type option[value="'+paymenttype+'"]').prop('selected', true);
            
        }else if(type=="3"){
            $(this1).html(this.getInputHTML_b("daysinput",tdvalue,id,group_id,scheduletype));    
        }else if(type=="4"){
            $(this1).html(this.getInputHTML_b("cycle",v1,id,group_id,scheduletype));    
            $('#cycle option[value="'+v1+'"]').prop('selected', true);
        }else if(type=="5"){
            $(this1).html(this.getInputHTML_b("doubleinput",v1,id,group_id,scheduletype));    
        }else if(type=="7"){
            $(this1).html(this.getInputHTML_b("doubleinput1",v1,id,group_id,scheduletype));    
        }else if(type=="6"){

            $(this1).html(this.getInputHTML_b("input_dropdown_6",tdvalue,id,group_id,scheduletype));    
            $('#type option[value="'+paymenttype+'"]').prop('selected', true);
            
        }
        else if(type=="8"){

            $(this1).html(this.getInputHTML_b("input_dropdown_8",tdvalue,id,group_id,scheduletype));    
            $('#type option[value="'+paymenttype+'"]').prop('selected', true);
            
        }
        else if(type=="12"){

            $(this1).html(this.getInputHTML_b("cycleb",v1,id,group_id,scheduletype));    
            $('#cycleb option[value="'+v1+'"]').prop('selected', true);
            
        }
        

        $(this1).prop("onclick", null).off("click");
    }
        
    editRow(indexOfCallingRow) {
        let indexOfCallingRowSanitized = indexOfCallingRow+1;
        //if command is called on the same row, save the values
        if (this.rowInEditMode===indexOfCallingRowSanitized) {
            this.saveValues();
            return;
        }
        //if command is called on a different row, reset
        if (this.rowInEditMode) {
            this.resetRow();
        }
        let c = this.editRowSettings;
        this.setRowEditMode(indexOfCallingRowSanitized);
        this.setOriginalRowValuesFor(indexOfCallingRowSanitized);
        let row = $(this.table).find('tr').eq(indexOfCallingRowSanitized);
        row.find('td').each((index, element)=>{
            if(index in c) {
                $(element).html(this.getInputHTML(element, index, c));
            }
        });
    }

    setRowEditMode (index) {
        this.rowInEditMode = index;
    }

    setOriginalRowValuesFor (index) {
        this.originalRowValues=this.dataTable.row(index-1);
    }

    setOutput(index) {
        let row = $(this.table).find('tr').eq(index).find('td');
        row.each((index, element) => {
            let htmlCell = element;
            if(index in this.editRowSettings) {
                let htmlElement = $('#'+this.classIdOf(index));
                let tagName = htmlElement.prop("tagName");
                $(element).html(htmlElement.val());
                this.dataTable.cell(element._DT_CellIndex.row, element._DT_CellIndex.column).data(htmlElement.val());
            }
        });
    }

    /*save value needs to
     - firstly, check if any row is being edited and could have new input,
     - secondly, set the output view (method setOutput()) and
     - thirdly, clear the edit modals (methods rowEditMode() and setOriginalRowValues())
    */
    saveValues () {
    if (this.rowInEditMode) {
        this.setOutput(this.rowInEditMode);
        this.setRowEditMode(null);
        this.setOriginalRowValues=null;
        $("[id*='tooltip']" ).remove();
    }
    }

    resetRow (index) {
        $(this.table).find('tr').eq(index).html(this.originalRowValues);
    }

    resetRow () {
        if (this.rowInEditMode) {
            this.dataTable.row(this.rowInEditMode-1).data(this.originalRowValues.data());
            this.dataTable.draw(false);
            this.setRowEditMode(null);
            this.setOriginalRowValuesFor(null);
        }
    }


    classIdOf(index) {
        if (this.editRowSettings[index])
            return this.editRowSettings[index].type+'_'+index;
        else {
            console.log(index + " is not configured for editing.")
        }
    }

    getInputHTML_b(inputType,value,id,group_id,scheduletype) {
        let html = "";
        switch (inputType) {
            case "input":
                return '<input id="textbox" class="form-control" type="text" value="'+value+'">&nbsp;<i class="fas far fa-save vdesc" data-group_id="'+group_id+'" data-scheduletype="'+scheduletype+'" alt="'+id+'"></i>&nbsp;<a href="javascript:void(0)" class=" vback" style="color:red;font-weight:bold;"><i class="fas far fa-ban" alt="'+id+'"></i></a>'
            case "checkbox":
                var checked='';
                if(value==1){
                    checked='checked';

                }
                return '<input id="agentstatment" '+checked+' class="form-control" type="checkbox" data-group_id="'+group_id+'" data-scheduletype="'+scheduletype+'" alt="'+id+'">'

            case "checkbox1":
                var checked='';
                if(value==1){
                    checked='checked';

                }
                return '<input id="merchantstatment" '+checked+' class="form-control" type="checkbox" data-group_id="'+group_id+'" data-scheduletype="'+scheduletype+'" alt="'+id+'">'

            case "doubleinput":
                        var splitval='';
                        var splitval1='';
                        var splitval2='';
                        if(value!="--"){
                            splitval=value.split("/");
                            splitval1=splitval[0];
                            splitval2=splitval[1];                            
                        }
                return '<input id="textbox1" class="form-control" type="text" value="'+splitval1+'">/<input id="textbox2" class="form-control" type="text" value="'+splitval2+'">&nbsp;<i class="fas far fa-save vproductsplit" data-group_id="'+group_id+'" data-scheduletype="'+scheduletype+'" alt="'+id+'"></i>&nbsp;<a href="javascript:void(0)" class=" vback" style="color:red;font-weight:bold;"><i class="fas far fa-ban" alt="'+id+'"></i></a>'

            case "doubleinput1":
                        var splitval='';
                        var splitval1='';
                        var splitval2='';
                        if(value!="--"){
                            splitval=value.split("/");
                            splitval1=splitval[0];
                            splitval2=splitval[1];                            
                        }
                return '<input id="textbox1" class="form-control" type="text" value="'+splitval1+'">/<input id="textbox2" class="form-control" type="text" value="'+splitval2+'">&nbsp;<i class="fas far fa-save vagentplit" data-group_id="'+group_id+'" data-scheduletype="'+scheduletype+'" alt="'+id+'"></i>&nbsp;<a href="javascript:void(0)" class=" vback" style="color:red;font-weight:bold;"><i class="fas far fa-ban" alt="'+id+'"></i></a>'

            case "daysinput":
                return '<input id="vdays" class="form-control numberonly" type="text" value="'+value+'">&nbsp;<i class="fas far fa-save vdays" data-group_id="'+group_id+'" data-scheduletype="'+scheduletype+'" alt="'+id+'"></i>&nbsp;<a href="javascript:void(0)" class=" vback" style="color:red;font-weight:bold;"><i class="fas far fa-ban" alt="'+id+'"></i></a>'    
            case "input_dropdown":
                return '<input id="price" class="form-control" type="text" value="'+value+'">&nbsp;<select id="type" class="form-control" style="padding:0px !important;"><option value="1">Flat Cost</option><option value="2">%</option></select><i class="fas far vprice fa-save" data-group_id="'+group_id+'" data-scheduletype="'+scheduletype+'" alt="'+id+'"></i>&nbsp;<a href="javascript:void(0)" class=" vback" style="color:red;font-weight:bold;"><i class="fas far fa-ban" alt="'+id+'"></i></a>';
            case "input_dropdown_11":
                return '<input id="price" class="form-control" type="text" value="'+value+'">&nbsp;<select id="type" class="form-control" style="padding:0px !important;"><option value="1">Flat Cost</option><option value="2">%</option></select><i class="fas far vrefprice fa-save" data-group_id="'+group_id+'" data-scheduletype="'+scheduletype+'" alt="'+id+'"></i>&nbsp;<a href="javascript:void(0)" class=" vback" style="color:red;font-weight:bold;"><i class="fas far fa-ban" alt="'+id+'"></i></a>';
            case "input_dropdown_6":
                return '<input id="priceagentcost" class="form-control" type="text" value="'+value+'">&nbsp;<select id="type" class="form-control" style="padding:0px !important;"><option value="1">Flat Cost</option><option value="2">%</option></select><i class="fas far vagentcost fa-save" data-group_id="'+group_id+'" data-scheduletype="'+scheduletype+'" alt="'+id+'"></i>&nbsp;<a href="javascript:void(0)" class=" vback" style="color:red;font-weight:bold;"><i class="fas far fa-ban" alt="'+id+'"></i></a>';
            case "input_dropdown_8":
                return '<input id="priceagentcost" class="form-control" type="text" value="'+value+'">&nbsp;<select id="type" class="form-control" style="padding:0px !important;"><option value="1">Flat Cost</option><option value="2">%</option></select><i class="fas far vmerchantcost fa-save" data-group_id="'+group_id+'" data-scheduletype="'+scheduletype+'" alt="'+id+'"></i>&nbsp;<a href="javascript:void(0)" class=" vback" style="color:red;font-weight:bold;"><i class="fas far fa-ban" alt="'+id+'"></i></a>';
            case "cycle":
                    html = '<select id="cycle" class="form-control">';
                    html+="<option value='1'>1-7 days in arrears</option>";
                    html+="<option value='2'>Weekly</option>";
                    html+="<option value='3'>Week in arrears</option>";
                    html+="<option value='4'>Weekly 2 in arrears</option>";
                    html+="<option value='5'>Weekly 3 in arrears</option>";
                    html+="<option value='6'>Daily</option>";
                    html+="<option value='7'>Monthly</option>";
                    html+="<option value='8'>Monthly in arrears</option>";
                    html+="</select>"
                return html+'&nbsp;<i class="fas far fa-save vcycle" data-group_id="'+group_id+'" data-scheduletype="'+scheduletype+'" alt="'+id+'"></i>&nbsp;<a href="javascript:void(0)" class=" vback" style="color:red;font-weight:bold;"><i class="fas far fa-ban" alt="'+id+'"></i></a>';
                case "cycleb":
                        html = '<select id="cycleb" class="form-control">';
                        html+="<option value='1'>1-7 days in arrears</option>";
                        html+="<option value='2'>Weekly</option>";
                        html+="<option value='3'>Week in arrears</option>";
                        html+="<option value='4'>Weekly 2 in arrears</option>";
                        html+="<option value='5'>Weekly 3 in arrears</option>";
                        html+="<option value='6'>Daily</option>";
                        html+="<option value='7'>Monthly</option>";
                        html+="<option value='8'>Monthly in arrears</option>";
                        html+="</select>"
                    return html+'&nbsp;<i class="fas far fa-save bcycle" data-group_id="'+group_id+'" data-scheduletype="'+scheduletype+'" alt="'+id+'"></i>&nbsp;<a href="javascript:void(0)" class=" vback" style="color:red;font-weight:bold;"><i class="fas far fa-ban" alt="'+id+'"></i></a>';
                default:
                console.log("Unknown input type. Element stays untouched.");
                return '<td value='+$(element).text()+'></td>'

        }

    }

    getInputHTML(element, index, settings) {
        let inputType = settings[index]["type"];
        switch (inputType) {
            case "input":
                return '<input id=\''+ this.classIdOf(index) +'\' value=\''+$(element).text()+'\'></input>'
            case "select":
                let html = '<select id=\''+ this.classIdOf(index) +'\'>';
                let options = settings[index]["options"];
                for (let i = 1; i<=Object.keys(options).length; i++){
                    html+="<option value="+options[i].value+">"+options[i].title+"</option>"
                }
                html+="</select>"
                return html;
            default:
                console.log("Unknown input type. Element stays untouched.");
                return '<td value='+$(element).text()+'></td>'

        }

    }

}
