<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Invoice extends Model
{
    use LogsActivity;

    protected static $logAttributes = ['address', 'acct_template', 'invoicedate', 'duedate', 'merchant', 'merchant_name', 'usertype', 'amount', 'balance', 'status', 'type'];
    protected static $logOnlyDirty = true;
    protected static $submitEmptyLogs = false;

    /**
     * Define activity log options for Spatie Activity Log.
     */
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logOnly(static::$logAttributes) // Log only the specified attributes
            ->logOnlyDirty(static::$logOnlyDirty) // Log only changed attributes
            ->dontSubmitEmptyLogs(static::$submitEmptyLogs);
    }

    public function items(){
        return $this->hasMany(InvoiceItem::class, 'invoice_id');
    }


    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->created_by = is_object(Auth::guard(config('app.guards.web'))->user()) 
                ? Auth::guard(config('app.guards.web'))->user()->id 
                : 1;

            $model->updated_by = is_object(Auth::guard(config('app.guards.web'))->user()) 
                ? Auth::guard(config('app.guards.web'))->user()->id 
                : 1;
        });

        static::updating(function ($model) {
            $model->updated_by = is_object(Auth::guard(config('app.guards.web'))->user()) 
                ? Auth::guard(config('app.guards.web'))->user()->id 
                : 1;
        });
    }
}
