<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use PDF;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

$formulatempdata = array();

class GenerateCommissionReportsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
        
    }
    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {        
      //\Log::info("commission job dispatched successfully");      
      //get records from commisions where status = 0, order by created_at desc
        $commissions = \App\Models\Commisions::where('status', 0)->orderBy('created_at', 'desc')->get();
      
      //loop through each record
        foreach($commissions as $commission){
            $errorsArray = array();
            //call csv parser for payarc report
            $response = $this->parseCSV($commission);
            if (count($response['errors']) > 0) {
                $errorsArray[] = $response['errors'];
            } 
            //call csv parser for nmi agent report
            if (!$response['aborted']) {
                $response = $this->parseNmiAgentCommCSV($commission);
                if (count($response['errors']) > 0) {
                    $errorsArray[] = $response['errors'];
                } 
            }
            //if no errors, continue doing the heavy lifting. generate pdf etc
            if (!$response['aborted']) {
                
                $this->generate_report($commission);
                
            }            
            //update commission record status to 1, json encode errors array and add to errors column
            $commission->status = 1;
            $commission->errors = json_encode($errorsArray);
            if (count($errorsArray) > 0) {
                $commission->status_text = "Report generated with errors";
                //log errorsarray
                \Log::info($errorsArray);
            } else {
                $commission->status_text = "Report generated";
            }
            $commission->save();
        }      
    }
    private function generate_report($commission)
    {  
        global $formulatempdata;
        $formulatempdata = array(); //clear the global array
        $profitandexpenseRPT = array();
        $agentRPT = array();
        $agentsArray = explode(',', $commission->agents);
        $agents = \App\Models\Agent::whereIn('id', $agentsArray)->get();
        //loop through agents then get all merchants assigned to that agent        
        foreach($agents as $agent)
        {
            $pdfinfo = array();
            $paidbynmi = array();
            $merchantresults = array();
            $alltheMerchants = array();
            $pdfdetailed = array();
            
            //get sub agents merrchants
            $subagentMerchants = \App\Models\Agent::where('parent_agent', $agent->id)->get();
            foreach($subagentMerchants as $subagentMerchant)
            {
                $subagentMerchantsArray = explode(',', $subagentMerchant->merchants);
                foreach($subagentMerchantsArray as $s)
                {
                    $alltheMerchants[] = $s;
                }                
            }
            //get the agent's merchants from merchants field.
            $merchantsArray = explode(',', $agent->merchants);
            foreach($merchantsArray as $merchantArray)
            {
                $alltheMerchants[] = $merchantArray;
            }
            //get merchants join banks table by merchants.bank_id. select banks.display_name
            $merchants = DB::table('merchants')->join('banks', 'merchants.bank_id', '=', 'banks.id')->select('merchants.*', 'banks.display_name as bank_display_name')->whereIn('merchants.id', $alltheMerchants)->get();                       
            //loop through merchants            
            foreach($merchants as $merchant)
            {                

                if ($merchant->id == 29)  //during testing i am using this merchant id
                {                      
                    
                    //get bank schdule id
                    $bankscheduleid = $merchant->bankscheduleid;
                    $agenscheduleid = $merchant->agentscheduleid;
                    $merchantscheduleid = $merchant->merchantscheduleid;                    
                    //if $bankscheduleid, $agenscheduleid and $merchantscheduleid are not null or empty, get the productassigns recor
                    if (strlen($bankscheduleid)>0 && strlen($agenscheduleid)>0 && strlen($merchantscheduleid)>0)                    
                    {                          

                        //calculate paid by nmi
                        $paidbynmi[$merchant->id] = $this->calculatePaidByNmi($merchant->merchant_number,$commission->id,$agent->id);
                        $merchantresults = array(); 
                        //get agents_paid_on from products_groups table where id = $agenscheduleid
                        $agentpaidon = \App\Models\Group::where('id', $agenscheduleid)->first();                        
                        $products = DB::select("
                                SELECT
                                description,
                                MAX(name) AS name,
                                MAX(product_cost_bank_3rd_party) AS product_cost_bank_3rd_party,
                                MAX(type) AS type,
                                MAX(prdouct_split) AS prdouct_split,
                                MAX(bank_payment_cycle) AS bank_payment_cycle,
                                MAX(free_source) AS free_source,
                                MAX(agent_cost) AS agent_cost,
                                MAX(agent_cost_type) AS agent_cost_type,
                                MAX(agent_split) AS agent_split,
                                MAX(agent_statement) AS agent_statement,
                                MAX(refferal_agent_commission) AS refferal_agent_commission,
                                MAX(agent_payment_cycle) AS agent_payment_cycle,
                                MAX(merchant_type) AS merchant_type,
                                MAX(merchant_cost) AS merchant_cost,
                                MAX(merchant_statement) AS merchant_statement,
                                MAX(billing_frequency) AS billing_frequency,
                                MAX(refferal_type) AS refferal_type,
                                MAX(id) AS id
                            FROM (
                                SELECT description,name, product_cost_bank_3rd_party, type, prdouct_split, bank_payment_cycle, free_source, NULL as agent_cost, NULL as agent_cost_type, NULL as agent_split, NULL as agent_statement, NULL as refferal_agent_commission, NULL as agent_payment_cycle, NULL as merchant_type, NULL as merchant_cost, NULL as merchant_statement, NULL as billing_frequency, NULL as refferal_type, id
                                FROM products
                                WHERE group_id = ".$merchant->bankscheduleid."

                                UNION ALL

                                SELECT description,NULL as name, NULL as product_cost_bank_3rd_party, NULL as type, NULL as prdouct_split, NULL as bank_payment_cycle, NULL as free_source, agent_cost, agent_cost_type, agent_split, agent_statement, refferal_agent_commission, agent_payment_cycle, null as merchant_type, NULL as merchant_cost, NULL as merchant_statement, NULL as billing_frequency, refferal_type, NULL as id
                                FROM products
                                WHERE group_id = ".$merchant->agentscheduleid."

                                UNION ALL

                                SELECT description,NULL as name, NULL as product_cost_bank_3rd_party, null as type, NULL as prdouct_split, NULL as bank_payment_cycle, free_source, NULL as agent_cost, NULL as agent_cost_type, NULL as agent_split, NULL as agent_statement, NULL as refferal_agent_commission, NULL as agent_payment_cycle, merchant_type, merchant_cost, merchant_statement, billing_frequency, NULL as refferal_type, NULL as id
                                FROM products
                                WHERE group_id = ".$merchant->merchantscheduleid."
                            ) AS subquery                            
                            GROUP BY description
                            ORDER BY description; "); 
                            //formula 41 is skipped
                            $formulaStaticfield = array("formula_1692750609","formula 22","formula 38","formula 13","formula 37","formula 15","formula 40","formula 36","formula 23","formula 14","formula 26","formula 35","formula 1");
                            $formulaOnetimefield = array("formula 34","formula 33", "formula 32");
                            $formulaReturnNoCalc = array("formula 6","formula 7","formula 12","formula 11","formula 18","formula 30","formula 31","formula 39","formula 20","formula 33","formula 10","formula_1692750541","formula 8","formula 9","formula_1692750517","formula 28","formula 3","formula 24","formula 25","formula 4","formula 5","formula 29","formula 27","formula_1692750586","formula_1692750560","formula 21");
                        //loop through products
                        foreach($products as $product)
                        {
                            if (in_array($product->name, $formulaStaticfield)) 
                            {                                
                                $result = $this->formulaStaticfield($product,$agent,$merchant,$commission,$agentpaidon->agents_paid_on);
                                if ($result['oktodisplay'])
                                {
                                    $merchantresults[] = $this->buildMerchantResults($product,$merchant,$agent,$result);
                                } 
                            } else if (in_array($product->name,$formulaOnetimefield))
                            {
                                //one time fees
                                $result = $this->formulaOnetimefield($product,$agent,$merchant,$commission,$agentpaidon->agents_paid_on);
                                if ($result['oktodisplay'])
                                {
                                    $merchantresults[] = $this->buildMerchantResults($product,$merchant,$agent,$result);
                                } 
                            }else if ($product->name == "formula 16")
                            {
                                //amex opt blue
                                $result = $this->formula16($product,$agent,$merchant,$commission,$agentpaidon->agents_paid_on);
                                if ($result['oktodisplay'])
                                {
                                    $merchantresults[] = $this->buildMerchantResults($product,$merchant,$agent,$result);
                                } 
                            } else if ($product->name == "formula 19") 
                            {                                
                                //annual fees
                                $result = $this->formulaAnnualfield($product,$agent,$merchant,$commission,$agentpaidon->agents_paid_on);
                                if ($result['oktodisplay'])
                                {
                                    $merchantresults[] = $this->buildMerchantResults($product,$merchant,$agent,$result);
                                } 
                            } else if (in_array($product->name,$formulaReturnNoCalc)) 
                            {                                
                                //no calculations for now
                                $result = $this->formulaNoCalc($product,$agent,$merchant,$commission,$agentpaidon->agents_paid_on);
                                if ($result['oktodisplay'])
                                {
                                    $merchantresults[] = $this->buildMerchantResults($product,$merchant,$agent,$result);
                                } 
                            }
                            else if ($product->name == "formula 17") 
                            {                                
                                //chargebacks from statement
                                $result = $this->formula17($product,$agent,$merchant,$commission,$agentpaidon->agents_paid_on);
                                if ($result['oktodisplay'])
                                {
                                    $merchantresults[] = $this->buildMerchantResults($product,$merchant,$agent,$result);
                                } 
                            }
                            else if ($product->name == "formula 2") 
                            {                                
                                //Interchange PLUS
                                $result = $this->formula2($product,$agent,$merchant,$commission,$agentpaidon->agents_paid_on);
                                if ($result['oktodisplay'])
                                {
                                    $merchantresults[] = $this->buildMerchantResults($product,$merchant,$agent,$result);
                                } 
                            }
                            else
                            {
                                //do nothing.
                            }
                                       
                        }
                        //get payarc residual report data
                        $payarcresidualreport = DB::table('commissions_risualreport')->where('mid', '=', $merchant->merchant_number)->where('commission_id', '=', $commission->id)->first();
                        $totalexpensepayarcpercntge = $payarcresidualreport->expense / $payarcresidualreport->revenue;
                        $payarcexpensepercentage = $totalexpensepayarcpercntge * $payarcresidualreport->agent_income;
                        $expensecolumn = $payarcresidualreport->agent_income - $payarcexpensepercentage;
                        //sum items. add to $profitandexpenseRPT, $agentRPT
                        $total_bank_cost = 0;
                        $total_split_revenue = 0;
                        $total_company_commission = 0;
                        $total_agent_commission = 0;
                        $total_agent_cost = 0;
                        foreach($merchantresults as $merchantresult)
                        {
                            $total_bank_cost += $merchantresult['bank_cost'];
                            $total_split_revenue += $merchantresult['split_revenue'];
                            $total_company_commission += $merchantresult['company_commission'];
                            $total_agent_commission += $merchantresult['agent_commission'];
                            $total_agent_cost += $merchantresult['agent_cost'];                            
                        }
                        $profitandexpenseRPT[] = array(
                            'processing_month' => Carbon::parse($commission->report_date)->format('m-y'),
                            'merchant_name' => $merchant->name,
                            'bank_display_name' => $merchant->bank_display_name,
                            'agent_name' => $agent->name,
                            'total_bank_cost' => $total_bank_cost,
                            'total_agent_cost' => $total_agent_cost,
                            'total_company_commission' => $total_company_commission,
                            'total_agent_commission' => $total_agent_commission,
                            'total_merchant_cost' => 0,                            
                        );
                        $agentRPT[] = array(                            
                            'merchant_name' => $merchant->name,
                            'bank_display_name' => $merchant->bank_display_name,
                            'agent_name' => $agent->name,
                            'agent_id' => $agent->id,
                            'total_bank_cost' => $total_bank_cost,
                            'total_split_revenue' => $total_split_revenue,
                            'total_company_commission' => $total_company_commission,
                            'total_agent_commission' => $total_agent_commission,
                            'total_merchant_cost' => 0,
                            'total_card_authorizations' => $payarcresidualreport->card_authorizations,
                            'total_captures' => $payarcresidualreport->captures,
                            'total_sales' => $payarcresidualreport->captured_sales,
                            'total_revenue' => $total_agent_commission,
                            'total_agent_cost' => $total_agent_cost,
                            'total_expense' => $expensecolumn,
                            'total_agent_income' => $payarcexpensepercentage,
                            'total_split' => '50%', //this is hard coded now but later should read this from the banks table
                            'total_paid_by_nmi' => $paidbynmi[$merchant->id],
                        );
                        $pdfdetailed[$merchant->id] = array(
                            'agent_name' => $agent->name,
                            'agent_id' => $agent->id,
                            'merchant_name' => $merchant->name,
                            'report_date' => Carbon::parse($commission->report_date)->format('m-y'),
                            'scheduletdata' => $merchantresults,
                        );

                        //this formula needs to be at the end because it works off the total of all the other formulas. am not really using any data from the product table for this formula
                        /*
                        $product = \App\Models\Product::where('name', 'formula 2')->orWhere('group_id', $agenscheduleid)->orWhere('group_id', $merchantscheduleid)->first();                        
                        if ($product != null)
                        {                            
                            $result = $this->formula2($product,$agent->id,$merchant->merchant_number,$commission->id,$commission->report_date,$merchant->schedule_type,$merchantresults);
                            if ($result['oktodisplay'])
                            {
                                $merchantresults[] = array('disc' => $product->description, 'col2' => $result['col2'], 'col3' => $result['col3'], 'result' => $result['result'],'merchant_id'=>$merchant->id) ;
                            }
                        }
                        */

                    } 
                    
                }
                
            } 
            //\Log::info($profitandexpenseRPT);
            //\Log::info($agentRPT);            
            //** save agent report PDF **            
            $pdfinfo[] = array(
                'agent_name' => $agent->name,
                'agent_id' => $agent->id,
                'report_date' => Carbon::parse($commission->report_date)->format('m-y'),
                'merchantdata' => $agentRPT,
            );                           
            $pdf_attachment = PDF::loadView('products.commissionpdf',compact('pdfinfo'))->setPaper('a4', 'portrait');
            //save pdf to public/reports folder
            //if the folder doesn't exists, create it
            if (!file_exists(public_path('reports'))) {
                mkdir(public_path('reports'), 0777, true);
            }
            $report_name = uniqid().'_'.$agent->id.'.pdf'; 
            $report_detailed_name = uniqid().'_det_'.$agent->id.'.pdf';            
            $pdf_attachment->save(public_path('reports/'.$report_name));
            $pdf_detailed = PDF::loadView('products.commissionpdfdetailed',compact('pdfdetailed'))->setPaper('a4', 'portrait');
            $pdf_detailed->save(public_path('reports/'.$report_detailed_name));            

            //save to commisions_details table agent_id and location of pdf file
            $commission_detail = new \App\Models\CommisionsDetail;
            $commission_detail->agent_id = $agent->id;
            $commission_detail->agent_name = $agent->name;
            $commission_detail->commisions_id = $commission->id;
            $commission_detail->report_location = $report_name;
            $commission_detail->report_detailed_location = $report_detailed_name;
            $commission_detail->save();      

        }
        //save values from $profitandexpenseRPT array to csv file then update commisions table with location of csv file
        if (count($profitandexpenseRPT) > 0) 
        {
            if (!file_exists(public_path('reports'))) {
                mkdir(public_path('reports'), 0777, true);
            }
            $peuid = uniqid();
            $profitandexpenseRPTcsv = fopen(public_path('reports/'.$peuid.'_profitandexpense.csv'), "w");
            fputcsv($profitandexpenseRPTcsv, array('processing_month','merchant_name','bank_display_name','agent_name','total_bank_cost','total_agent_cost','total_company_commission','total_agent_commission','total_merchant_cost'));
            foreach ($profitandexpenseRPT as $line) {
                fputcsv($profitandexpenseRPTcsv, $line);
            }
            fclose($profitandexpenseRPTcsv);
            $commission->profit_expense_file = $peuid.'_profitandexpense.csv';
            $commission->save();
        }
        



    }
    private function buildMerchantResults($product,$merchant,$agent,$result)
    {
        $merchantresult = array();
        $merchantresult['disc'] = $product->description; 
        $merchantresult['merchangt_name'] = $merchant->name;
        $merchantresult['bank_display_name'] = $merchant->bank_display_name;
        $merchantresult['agent_name'] = $agent->name;
        $merchantresult['bank_cost'] = $result['bank_cost'];
        $merchantresult['split_revenue'] = $result['split_revenue'];
        $merchantresult['company_commission'] = $result['company_commission'];
        $merchantresult['agent_commission'] = $result['agent_commission'];
        $merchantresult['agent_cost'] = $result['agent_cost'];
        $merchantresult['merchant_cost'] = $result['merchant_cost'];                                        
        $merchantresult['merchant_id']=$merchant->id;
        $merchantresult['merchant_number']=$merchant->merchant_number;
        $merchantresult['card_authorizations'] = $result['card_authorizations'];
        $merchantresult['captures'] = $result['captures'];
        $merchantresult['sales'] = $result['sales'];
        $merchantresult['revenue'] = 0;
        $merchantresult['expense'] = $result['expense'];
        $merchantresult['Split'] = '50%'; //this is hard coded now but later should read this from the banks table
        $merchantresult['agent_income'] = 0;
        return $merchantresult;

    }    
    
    
    private function formulaNoCalc($product,$agent,$merchant,$commission,$agents_paid_on) 
    {
        //Auth & Capture (Visa/MC/DS/Amex)
        // currently this function just returns because we don't yet have a sample statement to get this data from
        global $formulatempdata;
        $result = array();
        $report_date = Carbon::parse($commission->report_date)->format('m-y');        
        $result['oktodisplay'] = true;
        $result['bank_cost'] = 0;
        $result['split_revenue'] = 0;
        $result['company_commission'] = 0;
        $result['agent_commission'] = 0;
        $result['agent_cost'] = 0; //when the agent under sells, he/she incurrs a cost
        $result['merchant_cost'] = 0;
        $result['card_authorizations'] = 0;
        $result['captures'] = 0;
        $result['sales'] = 0;
        $result['expense'] = 0;
        
        return $result;

    }

    private function formula2($product,$agent,$merchant,$commission,$agents_paid_on) 
    {
        //Interchange PLUS
        global $formulatempdata;
        $result = array();
        $report_date = Carbon::parse($commission->report_date)->format('m-y');        
        $result['oktodisplay'] = true;
        $result['bank_cost'] = 0;
        $result['split_revenue'] = 0;
        $result['company_commission'] = 0;
        $result['agent_commission'] = 0;
        $result['agent_cost'] = 0; //when the agent under sells, he/she incurrs a cost
        $result['merchant_cost'] = 0;
        $result['card_authorizations'] = 0;
        $result['captures'] = 0;
        $result['sales'] = 0;
        $result['expense'] = 0;
        $amountofsales = 0;
        $netsales = 0;
        $plansummary= DB::table('st_plansummary')->where('merchant_number', '=', $merchant->merchant_number)->where('processing_month', '=', $report_date)->where('plan_code', '=', '**')->first();       
        $amountofsales = $this->numbers_only($plansummary->amount_of_sales);
        $netsales = $this->numbers_only($plansummary->new_sales);       
            
        if ($product->type == 2 && $product->agent_cost_type ==2 && $product->merchant_type == 2) 
        {
            //we only continue processing if these ARE in percentages
            $bankcost = ($product->product_cost_bank_3rd_party / 100) * $amountofsales;
            $agentcost = ($product->agent_cost / 100) * $netsales;
            $merchantcost = ($product->merchant_cost / 100) * $netsales;;                         
            $resulttobe = $this->calculateMoniesstatic($product,$agent,$merchant,$commission,$agents_paid_on,$bankcost,$agentcost,$merchantcost);
            $result['agent_commission'] = $resulttobe['agent_commission'];
            $result['agent_cost'] = $resulttobe['agent_cost'];
            $result['bank_cost'] = $resulttobe['bank_cost'];
            $result['company_commission'] = $resulttobe['company_commission'];
        }  
        return $result;
    }

    private function formula17($product,$agent,$merchant,$commission,$agents_paid_on) 
    {
        //chargebacks from statement
        global $formulatempdata;
        $result = array();
        $report_date = Carbon::parse($commission->report_date)->format('m-y');        
        $result['oktodisplay'] = true;
        $result['bank_cost'] = 0;
        $result['split_revenue'] = 0;
        $result['company_commission'] = 0;
        $result['agent_commission'] = 0;
        $result['agent_cost'] = 0; //when the agent under sells, he/she incurrs a cost
        $result['merchant_cost'] = 0;
        $result['card_authorizations'] = 0;
        $result['captures'] = 0;
        $result['sales'] = 0;
        $result['expense'] = 0;
        $chargebacks = 0;
        $plansummary= DB::table('st_fee')->where('merchant_number', '=', $merchant->merchant_number)->where('processing_month', '=', $report_date)->where('section', '=', 'TRANSACTION FEES')->where('description', '=', 'Chargeback Fees')->first();       
        $chargebacks = $plansummary->count ?? 0;
        if ($chargebacks > 0)
        {
            
            if ($product->type == 1 && $product->agent_cost_type ==1) 
            {
                //we only continue processing if these are NOT in percentage
                $bankcost = $product->product_cost_bank_3rd_party * $chargebacks;
                $agentcost = $product->agent_cost * $chargebacks;
                $merchantcost = $product->merchant_cost * $chargebacks; 
                //log chargeback test               
                $resulttobe = $this->calculateMoniesstatic($product,$agent,$merchant,$commission,$agents_paid_on,$bankcost,$agentcost,$merchantcost);
                $result['agent_commission'] = $resulttobe['agent_commission'];
                $result['agent_cost'] = $resulttobe['agent_cost'];
                $result['bank_cost'] = $resulttobe['bank_cost'];
                $result['company_commission'] = $resulttobe['company_commission'];
            }            
        }

        return $result;
    }
    
    private function formula16($product,$agent,$merchant,$commission,$agents_paid_on) 
    {
        //amex opt blue
        global $formulatempdata;
        $result = array();
        $report_date = Carbon::parse($commission->report_date)->format('m-y');        
        $result['oktodisplay'] = true;
        $result['bank_cost'] = 0;
        $result['split_revenue'] = 0;
        $result['company_commission'] = 0;
        $result['agent_commission'] = 0;
        $result['agent_cost'] = 0; //when the agent under sells, he/she incurrs a cost
        $result['merchant_cost'] = 0;
        $result['card_authorizations'] = 0;
        $result['captures'] = 0;
        $result['sales'] = 0;
        $result['expense'] = 0;
        $amexsales = 0;
        $plansummary= DB::table('st_plansummary')->where('merchant_number', '=', $merchant->merchant_number)->where('processing_month', '=', $report_date)->where('plan_code', '=', 'AM')->first();
        if ($agents_paid_on == "gross_sales") 
        {                
            $amexsales = $plansummary->amount_of_sales ?? 0;            
        } else 
        {
            //net_sales
            $amexsales = $plansummary->new_sales ?? 0;            
        }
        if ($amexsales > 0)
        {
            
            if ($product->type == 1 || $product->agent_cost_type ==1) 
            {
                //if percentages weren't specified for these fileds, use standard calculations
                $bankcost = $product->product_cost_bank_3rd_party;
                $agentcost = $product->agent_cost;
                $merchantcost = $product->merchant_cost; 
                $resulttobe = $this->calculateMoniesstatic($product,$agent,$merchant,$commission,$agents_paid_on,$bankcost,$agentcost,$merchantcost);
                $result['agent_commission'] = $resulttobe['agent_commission'];
                $result['agent_cost'] = $resulttobe['agent_cost'];
                $result['bank_cost'] = $resulttobe['bank_cost'];
                $result['company_commission'] = $resulttobe['company_commission'];                

            } else 
            {
                $bankcost_percent = $product->product_cost_bank_3rd_party / 100;
                $agentcost_percent = $product->agent_cost / 100;
                $merchantcost_percent = $product->merchant_cost / 100;
                $bankcost = $amexsales * $bankcost_percent;
                $agentcost = $amexsales * $agentcost_percent;
                $merchantcost = $amexsales * $merchantcost_percent;
                $resulttobe = $this->calculateMoniesstatic($product,$agent,$merchant,$commission,$agents_paid_on,$bankcost,$agentcost,$merchantcost);
                $result['agent_commission'] = $resulttobe['agent_commission'];
                $result['agent_cost'] = $resulttobe['agent_cost'];
                $result['bank_cost'] = $resulttobe['bank_cost'];
                $result['company_commission'] = $resulttobe['company_commission'];                

            }
        }

        return $result;

    }

    private function formulaAnnualfield($product,$agent,$merchant,$commission,$agents_paid_on) 
    {        
         global $formulatempdata;
         $result = array();
         $report_date = Carbon::parse($commission->report_date)->format('m-y');        
         $result['oktodisplay'] = true;
         $result['bank_cost'] = 0;
         $result['split_revenue'] = 0;
         $result['company_commission'] = 0;
         $result['agent_cost'] = 0; //when the agent under sells, he/she incurrs a cost
         $result['agent_commission'] = 0;
         $result['merchant_cost'] = 0;
         $result['card_authorizations'] = 0;
         $result['captures'] = 0;
         $result['sales'] = 0;
         $result['expense'] = 0;        
         //calculate bank cost
         if ($product->type == 2 || $product->merchant_type ==2) 
         {
         //if any of these = 2 (perentage), return. we don't process percentages here
         return $result;             
         }
         //using DB::table select from product_charges table where agent_id = $agent->id and formula_name = $product->name         
         $product_charges = DB::table('products_charges')->where('agent_id', '=', $agent->id)->where('formula_name', '=', $product->name)->first();         
         if ($product_charges == null)
         {
             $bankcost = $product->product_cost_bank_3rd_party;
             $agentcost = $product->agent_cost;
             $merchantcost = $product->merchant_cost; 
             $resulttobe = $this->calculateMoniesstatic($product,$agent,$merchant,$commission,$agents_paid_on,$bankcost,$agentcost,$merchantcost); 
             $result['agent_commission'] = $resulttobe['agent_commission'];
             $result['agent_cost'] = $resulttobe['agent_cost'];
             $result['bank_cost'] = $resulttobe['bank_cost'];
             $result['company_commission'] = $resulttobe['company_commission']; 
             //using DB::table add new record product_charges table with commission_id, agent_id, formula_name, lastcharged
             DB::table('products_charges')->insert(['commission_id' => $commission->id,'formula_name' => $product->name,'agent_id' => $agent->id,'lastcharged' => Carbon::now()]);
         } else 
         {
            //the agent has been charged for this product before. check if it's been more than a year
            $lastcharged = Carbon::parse($product_charges->lastcharged);
            $now = Carbon::now();
            $diff = $lastcharged->diffInDays($now);
            if ($diff > 365) 
            {
                //it's been more than a year. charge the agent again
                $bankcost = $product->product_cost_bank_3rd_party;
                $agentcost = $product->agent_cost;
                $merchantcost = $product->merchant_cost; 
                $resulttobe = $this->calculateMoniesstatic($product,$agent,$merchant,$commission,$agents_paid_on,$bankcost,$agentcost,$merchantcost); 
                $result['agent_commission'] = $resulttobe['agent_commission'];
                $result['agent_cost'] = $resulttobe['agent_cost'];
                $result['bank_cost'] = $resulttobe['bank_cost'];
                $result['company_commission'] = $resulttobe['company_commission']; 
                //using DB::table add new record product_charges table with commission_id, agent_id, formula_name, lastcharged
                DB::table('products_charges')->insert(['commission_id' => $commission->id,'formula_name' => $product->name,'agent_id' => $agent->id,'lastcharged' => Carbon::now()]);
            } 

         }
         return $result;
 
    }

   private function formulaOnetimefield($product,$agent,$merchant,$commission,$agents_paid_on) 
   {        
        global $formulatempdata;
        $result = array();
        $report_date = Carbon::parse($commission->report_date)->format('m-y');        
        $result['oktodisplay'] = true;
        $result['bank_cost'] = 0;
        $result['split_revenue'] = 0;
        $result['company_commission'] = 0;
        $result['agent_cost'] = 0; //when the agent under sells, he/she incurrs a cost
        $result['agent_commission'] = 0;
        $result['merchant_cost'] = 0;
        $result['card_authorizations'] = 0;
        $result['captures'] = 0;
        $result['sales'] = 0;
        $result['expense'] = 0;        
        //calculate bank cost
        if ($product->type == 2 || $product->merchant_type ==2) 
        {
        //if any of these = 2 (perentage), return. we don't process percentages here
        return $result;             
        }
        //using DB::table select from product_charges table where agent_id = $agent->id and formula_name = $product->name
        $product_charges = DB::table('products_charges')->where('agent_id', '=', $agent->id)->where('formula_name', '=', $product->name)->first();
        if ($product_charges != null)
        {
            $bankcost = $product->product_cost_bank_3rd_party;
            $agentcost = $product->agent_cost;
            $merchantcost = $product->merchant_cost; 
            $resulttobe = $this->calculateMoniesstatic($product,$agent,$merchant,$commission,$agents_paid_on,$bankcost,$agentcost,$merchantcost); 
            $result['agent_commission'] = $resulttobe['agent_commission'];
            $result['agent_cost'] = $resulttobe['agent_cost'];
            $result['bank_cost'] = $resulttobe['bank_cost'];
            $result['company_commission'] = $resulttobe['company_commission']; 
            //using DB::table add new record product_charges table with commission_id, agent_id, formula_name, lastcharged
            DB::table('products_charges')->insert(['commission_id' => $commission->id,'formula_name' => $product->name,'agent_id' => $agent->id,'lastcharged' => Carbon::now()]);
        }
        return $result;

   }

    private function formulaStaticfield($product,$agent,$merchant,$commission,$agents_paid_on)
    {     
       
        global $formulatempdata;
        $result = array();
        $report_date = Carbon::parse($commission->report_date)->format('m-y');        
        $result['oktodisplay'] = true;
        $result['bank_cost'] = 0;
        $result['split_revenue'] = 0;
        $result['company_commission'] = 0;
        $result['agent_cost'] = 0; //when the agent under sells, he/she incurrs a cost
        $result['agent_commission'] = 0;
        $result['merchant_cost'] = 0;
        $result['card_authorizations'] = 0;
        $result['captures'] = 0;
        $result['sales'] = 0;
        $result['expense'] = 0;
        if ($product->type == 2 || $product->merchant_type ==2) 
        {
           //if any of these = 2 (perentage), return. we don't process percentages here
           return $result;             
        }
        $bankcost = $product->product_cost_bank_3rd_party;
        $agentcost = $product->agent_cost;
        $merchantcost = $product->merchant_cost; 
        $resulttobe = $this->calculateMoniesstatic($product,$agent,$merchant,$commission,$agents_paid_on,$bankcost,$agentcost,$merchantcost); 
        $result['agent_commission'] = $resulttobe['agent_commission'];
        $result['agent_cost'] = $resulttobe['agent_cost'];
        $result['bank_cost'] = $resulttobe['bank_cost'];
        $result['company_commission'] = $resulttobe['company_commission'];  
                
        return $result;
    }
    private function calculateMoniesstatic($product,$agent,$merchant,$commission,$agents_paid_on,$bankcost,$agentcost,$merchantcost) 
    {
        $result = array();
        $report_date = Carbon::parse($commission->report_date)->format('m-y');        
        $result['oktodisplay'] = true;
        $result['bank_cost'] = 0;
        $result['split_revenue'] = 0;
        $result['company_commission'] = 0;
        $result['agent_commission'] = 0;
        $result['agent_cost'] = 0; //when the agent under sells, he/she incurrs a cost
        $result['merchant_cost'] = 0;
        $result['card_authorizations'] = 0;
        $result['captures'] = 0;
        $result['sales'] = 0;
        $result['expense'] = 0;             
        if ($merchantcost > 0) 
        {
            //if the agent is charging the merchant something then we need to split it with the bank
            $providerSplitArray = explode('/', $product->prdouct_split);
            $agentSplitArray = explode('/', $product->agent_split);
            if (empty($providerSplitArray[0]) || empty($providerSplitArray[1]) || empty($agentSplitArray[0]) || empty($agentSplitArray[1])) { return $result; }
            $providerSplitArray[1] = $providerSplitArray[1] / 100;
            $providerSplitArray[0] = $providerSplitArray[0] / 100;
            $agentSplitArray[0] = $agentSplitArray[0] / 100;
            $agentSplitArray[1] = $agentSplitArray[1] / 100;
            $merchantcost_banksplit = $merchantcost * $providerSplitArray[1]; //the bank is getting a split of what the merchant is paying aka what the agent charged the merchant 
            $merchantcost_banksplit2 = $merchantcost * $providerSplitArray[0]; //the other side of this money is devided between the agent and Hirisk Processor
            $merchantagntcostDiff = $merchantcost - $agentcost;
            if ($merchantagntcostDiff > 0) 
            {
               $agentmoney = $merchantagntcostDiff * $agentSplitArray[0]; //agent gets his split of what he charged the merchant
               $result['agent_commission'] = $agentmoney;               
               $result['bank_cost'] = $merchantcost_banksplit;
               $result['company_commission'] = $merchantcost_banksplit2 - $merchantagntcostDiff;
               // ** canculation done. However, i think one side should be given to hirisk processor and the other side to agent. 
            } else 
            {                
                $result['agent_cost'] = $merchantagntcostDiff;
                $result['bank_cost'] = $merchantcost_banksplit;
                $result['company_commission'] = $merchantcost_banksplit2;                
            }

        } else 
        {
            //if the agent didn't charge the merchant anything then we have nothing to split with the bank
            $result['company_commission'] = $agentcost - $bankcost;
            $result['bank_cost'] = $bankcost;
        }       

        return $result;

    }
    // **********************************************
    // ************ HELPER FUNCTIONS *****************
    private function calculatePaidByNmi($merchantid,$commissionid,$agentid)
    {
        $total = 0;        
        //get sum of total_commission column from commissions_nmiagentreport table where merchant_id = $merchantid
        $total_commission = DB::table('commissions_nmiagentreport')->where('mid', '=', $merchantid)->where('commisions_id', '=', $commissionid)->where('agent_id', '=', $agentid)->sum('total_commission');        
        $total = $total_commission ?? 0;                
        return $total;
    }
    public function parseNmiAgentCommCSV($commission)
    {
        $response = array();        
        $response['aborted'] = false;
        $response['errors'] = array();
        $errorsArray = array();
        $header = array();
        //get nmi agent commission files from json formatted data in the nmiagentreport_file column        
        $nmiagentReportfiles = json_decode($commission->nmiagentreport_file);
        //loop through nmiagentReportfiles
        foreach ($nmiagentReportfiles as $key => $value)
        {           
            //check if file exists
            if (!file_exists($value)) {
                $errorsArray[] = "File does not exist. Please check the file and try again.";
                $response['aborted'] = true;
                $response['errors'] = $errorsArray;
                return $response;
            }
            //check if file is readable
            if (!is_readable($value)) {
                $errorsArray[] = "File is not readable. Please check the file and try again.";
                $response['aborted'] = true;
                $response['errors'] = $errorsArray;
                return $response;
            }
            //open file
            $file = fopen($value, "r");
            //get header row
            $fileheader = fgetcsv($file);
            //loop through fileheader getting only the fields i need
            for ($c=0; $c < count($fileheader); $c++) 
            {
                switch(strtolower($fileheader[$c]))
                {
                    case "merchant":
                        $header[$c] = "merchant";
                        break;
                    case "external identifier":
                        $header[$c] = "mid";
                        break;
                    case "fees":
                        $header[$c] = "fees";
                        break;
                    case "total commission":
                        $header[$c] = "total_commission";
                        break;                
                }            
            }

            //check if header row is valid
            if (count($header) != 4) {
                //get agent name from agents table
                $agent = \App\Models\Agent::where('id', $key)->first();
                $errorsArray[] = "There was a problem reading nmi agent report file for ".$agent->name.". The header rows we are looking for were not found. The file must at least have the following header rows: Merchant, External Identifier, Fees, Total Commission.";
                $response['aborted'] = true;
                $response['errors'] = $errorsArray;
                return $response;
            }
            //loop through each row of file
            while (($row = fgetcsv($file)) !== FALSE) 
            {
                $data= array();
                for ($c=0; $c < count($row); $c++) 
                {
                    //get data from row
                    if (isset($header[$c])) 
                    {
                        $data[$header[$c]] = $row[$c];
                    }                
                }
                //write data to commissions_nmiagentreport table
                $commission_nmiagentreport = new \App\Models\CommissionNmiAgentReport();
                $commission_nmiagentreport->merchant = $data['merchant'];
                $commission_nmiagentreport->mid = $data['mid'];
                $commission_nmiagentreport->fees = $data['fees'];
                $commission_nmiagentreport->total_commission = $this->numbers_only($data['total_commission']);
                $commission_nmiagentreport->commisions_id = $commission->id;
                $commission_nmiagentreport->agent_id = $key;
                $commission_nmiagentreport->save();

            }           
             //close file
            fclose($file);
            //check if public/uploads/rdatareports folder exists. if not create it
            if (!file_exists(public_path('uploads/rdatareports'))) {
                mkdir(public_path('uploads/rdatareports'), 0777, true);
            }
            //move file to public/uploads/rdatareports folder
            rename($value, public_path('uploads/rdatareports/'.basename($value)));            
        }
        return $response;
    }

    public function parseCSV($commission)
    {
        $response = array();        
        $response['aborted'] = false;
        $response['errors'] = array();
        $errorsArray = array();
        $header = array();
        //get file path
        $path = $commission->report_file;
        //check if file exists
        if (!file_exists($path)) {
            \Log::info("PayArc File does not exist, so i am aborting. It is possible this report already ran and the file was removed");
            exit;
        }
        //open file
        $file = fopen($path, "r");
        //get header row
        $fileheader = fgetcsv($file);
        //loop through fileheader getting only the fields i need
        for ($c=0; $c < count($fileheader); $c++) 
        {
            switch(strtolower($fileheader[$c]))
            {
                case "merchant":
                    $header[$c] = "merchant";
                    break;
                case "mid":
                    $header[$c] = "mid";
                    break;
                case "captured sales":
                    $header[$c] = "captured_sales";
                    break;
                case "captures":
                    $header[$c] = "captures";
                    break;
                case "revenue":
                    $header[$c] = "revenue";
                    break;
                case "expense":
                    $header[$c] = "expense";
                    break;
                case "gross profit":
                    $header[$c] = "gross_profit";
                    break;
                case "agent income":
                    $header[$c] = "agent_income";
                    break;
                case "%profit":
                    $header[$c] = "percent_profit";
                    break;
                case "split":
                    $header[$c] = "split";
                    break;
                case "card authorizations":
                    $header[$c] = "card_authorizations";
                    break;
                case "buy rate template":
                    $header[$c] = "buy_rate_template";
                    break;
            }            
        }

        //check if header row is valid
        if (count($header) <= 10) {
            $errorsArray[] = "There was a problem reading the PayArc Residual Report file. Most of the header rows such as Merchant, Mid, Captured Sales, Captures were not found. Please check the file and try again.";
            $response['aborted'] = true;
            $response['errors'] = $errorsArray;
            return $response;
        }
        //loop through each row
        while (($row = fgetcsv($file)) !== FALSE) {
            
            $data= array();
            for ($c=0; $c < count($row); $c++) 
            {
                //get data from row
                if (isset($header[$c])) 
                {
                    $data[$header[$c]] = $row[$c];
                }                
            }
            //write data to commissions_risualreport table
            $commission_risualreport = new \App\Models\CommissionRisualReport();
            $commission_risualreport->merchant = $data['merchant'];
            $commission_risualreport->mid = $this->formatPayarcMid($data['mid']);  //payarc mid for some reason always starts with 0. we have to remove it          
            $commission_risualreport->captured_sales = $this->numbers_only($data['captured_sales']);
            $commission_risualreport->captures = $data['captures'];
            $commission_risualreport->revenue = $this->numbers_only($data['revenue']);
            $commission_risualreport->expense = $this->numbers_only($data['expense']);
            $commission_risualreport->gross_profit = $this->numbers_only($data['gross_profit']);
            $commission_risualreport->agent_income = $this->numbers_only($data['agent_income']);
            $commission_risualreport->percent_profit = $data['percent_profit'];
            $commission_risualreport->split = $data['split'];
            $commission_risualreport->card_authorizations = $data['card_authorizations'];
            $commission_risualreport->buy_rate_template = $data['buy_rate_template'];
            $commission_risualreport->commission_id = $commission->id;
            $commission_risualreport->save();            
           
        }                 
        fclose($file);
        //check if public/uploads/rdatareports folder exists. if not create it
        if (!file_exists(public_path('uploads/payarcreports'))) {
            mkdir(public_path('uploads/payarcreports'), 0777, true);
        }
        //move file to public/uploads/rdatareports folder
        rename($path, public_path('uploads/payarcreports/'.basename($path)));        
        return $response;
    }
    private function numbers_only($string)
    {
        //remove all non numeric characters from string. leaving only numbers and decimal point
        return preg_replace("/[^0-9.]/", "", $string);       
    }
    private function formatPayarcMid($string) 
    {
        //if the first character is a zero remove it
        if (substr($string, 0, 1) == '0') {
            $string = substr($string, 1);
        }
        return $string;
    }   
}
