<?php
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
//use Exception;

function processPayarcWebhooks() 
{
      $whereArray = array();      
  // process raw json data        
      $select = "select id,data,created_at from webhooks WHERE source = 'payarcportal' and processed = 0";       
      $dbresults = DB::select($select); 
      foreach($dbresults as $row)  
      {
        unset($whereArray); 
        $jsondata = json_decode($row->data);
        if ($jsondata->event_type == "Dispute Won")
        {
          //chargeback_rdr_count, chargeback_rdr_amount
          $apiresponse = json_decode($jsondata->api_response); 
          if ($apiresponse->rdr_indicator == 1)
          {
            // make sure this case hasn't already been processed. sometimes i get duplicate webhooks
            $count = DB::table("whooktransactions_payarc")->where(['casenumber'=>$apiresponse->case_number])->where(['transactiondate'=>$apiresponse->transaction_date])->count();           
            if ($count <= 0)
            {
              //insert the case and the charge amounts into the whooktransactions_payarc table              
              unset($whereArray); 
              $whereArray['casenumber'] = $apiresponse->case_number;
              $whereArray['transactiondate'] = $apiresponse->transaction_date;         
              $whereArray['amount'] = $apiresponse->amount;
              $whereArray['reportdate'] = Carbon::parse($row->created_at)->format('Y-m-d'); 
              $whereArray['merchantid'] = $apiresponse->mid;        
              if(DB::insert("INSERT INTO whooktransactions_payarc (casenumber,transactiondate,amount,reportdate,merchantid) VALUES(:casenumber,:transactiondate,:amount,:reportdate,:merchantid)",$whereArray))
              {
                // update webhooks table that this webhook line has ben processed
                unset($whereArray); 
                $whereArray['id'] = $row->id;
                $updated  = DB::update("UPDATE webhooks SET processed = 1  WHERE id = :id ",$whereArray); 
                
              } else 
              {
                Log::debug("There was an error inserting records to the whooktransactions_payarc table for merchant ".$apiresponse->mid ." cron_reports table not updated");
              }                          
              //print_r($jsondata);              
              //exit;
            }
          }
          if ($apiresponse->rdr_indicator == 0) 
          {
              //we only need need rdr items. none rdr items are just marked as completed
              unset($whereArray); 
              $whereArray['id'] = $row->id;
              $updated  = DB::update("UPDATE webhooks SET processed = 1  WHERE id = :id ",$whereArray);             
          }
        } else 
        {
          unset($whereArray); 
          $whereArray['id'] = $row->id;
          $updated  = DB::update("UPDATE webhooks SET processed = 1  WHERE id = :id ",$whereArray);
        }
      }
      //update cron_reports table. since each day contains aggregate of previous days.
      unset($whereArray);
      $mynow = Carbon::now('America/New_York');
      //$mynow = "2022-12-01 06:57:53";
      $report_date_start =  Carbon::parse($mynow)->subDays('5')->format('Y-m-d'); //last 5 days
      $whereArray['report_date_start'] = $report_date_start; 
      $whereArray['report_date_end'] = Carbon::parse($mynow)->format('Y-m-d');
      //echo "now ->". $mynow;
      //return;
      $dbresults = DB::select("select id,report_date,merchant_number from cron_reports  WHERE report_date >= :report_date_start and report_date <= :report_date_end and (chargeback_rdr_amount = 0 or chargeback_rdr_amount is NULL)",$whereArray);
      foreach($dbresults as $row)
      {
        for($i = 0; $i < 31; $i++)
        {
          unset($whereArray); 
          $firstdayofgivenmonth = Carbon::parse(Carbon::parse($report_date_start)->addDays($i))->format('Y-m-1');
          $whereArray['mid'] = $row->merchant_number;
          $whereArray['reportdate_start'] = $firstdayofgivenmonth; 
          $whereArray['reportdate_end'] = Carbon::parse($report_date_start)->addDays($i)->format('Y-m-d');
          //has to be same month
          if (Carbon::parse($report_date_start)->addDays($i)->format('m') == Carbon::parse($row->report_date)->format('m'))
          {
            $dbresults2 = DB::select("select sum(amount) as amnt, count(id) as cnt,merchantid FROM whooktransactions_payarc WHERE merchantid = :mid AND reportdate >= :reportdate_start and reportdate <= :reportdate_end GROUP BY merchantid",$whereArray);
            foreach($dbresults2 as $row2)
            {                  
                // update cron_reports table with agregate data
                unset($whereArray); 
                $whereArray['chargeback_rdr_count'] = $row2->cnt;
                $whereArray['chargeback_rdr_amount'] = $row2->amnt;
                $whereArray['mid'] = $row->merchant_number;
                $whereArray['report_date'] = Carbon::parse($report_date_start)->addDays($i)->format('Y-m-d');
                $updated  = DB::update("UPDATE cron_reports SET chargeback_rdr_count = :chargeback_rdr_count, chargeback_rdr_amount = :chargeback_rdr_amount WHERE merchant_number = :mid AND report_date = :report_date ",$whereArray);
                if (!$updated) 
                {
                  Log::debug("Was not able to update cron_reports for ". $row->merchant_number);
                }
            }
          } 
          if (Carbon::parse($report_date_start)->addDays($i)->format('Y-m-d') == Carbon::parse($row->report_date)->format('Y-m-d'))  
          {
            break;
          }             
        }
      }

       



      //update the timer log that this timer has executed successfully
      unset($whereArray); 
      $whereArray['timername'] = 'Webhooks_payarcportal';
      $whereArray['lastsuccessrun'] = Carbon::parse(Carbon::now())->format('Y-m-d H:m:s');
      if(!DB::insert("INSERT INTO timerlogs (timername,lastsuccessrun) VALUES(:timername,:lastsuccessrun)",$whereArray)) 
      {
        Log::debug("Unable to update the timer log table for Webhooks_payarcportal");
      }
      
}

function updatecronreportStripeData($udate) 
{
  // report_date, sales_count, sales_amount, chargebacks_count, chargebacks_amount
  $from_date = "";
  $to_date = "";  
  $whereArray = array();
  if (empty($udate)) 
  {
    $udate = Carbon::now('America/New_York')->format('Y-m-d');
  }
  $from_date = date("Y-m-01",strtotime($udate)). " 00:00:00";  
  $to_date = date("Y-m-d",strtotime($udate)). " 23:59:59";
  // get sales and sales count then insert into cron_reports
  $select = "SELECT	id,count(id) as sales_count,date,merchantmd5id,sum(amount) as amt FROM	stripetransactions ";
	$select .= "WHERE transactiontype = 'AUTH_CAPTURE' AND responsetype = 'APPROVED' and date between :from_date and :to_date	GROUP BY merchantmd5id 	ORDER BY merchantmd5id  ";
  $whereArray['from_date'] = $from_date;
  $whereArray['to_date'] = $to_date;
  $dbresults = DB::select($select,$whereArray); 
 
  foreach($dbresults as $row) 
  {
      if (!empty($row->merchantmd5id) && !empty($row->date))
      {
        $whereArray2=array();
        $sql = "SELECT id from cron_reports WHERE report_date = :report_date AND merchant_number = :merchant_number"; // using select instead of replace into because this is faster
        $whereArray2['report_date'] = date("Y-m-d",strtotime($udate));
        $whereArray2['merchant_number'] = $row->merchantmd5id;
        $dbresults2 = DB::select($sql,$whereArray2);      
        $whereArray2['sales_count'] = $row->sales_count;
        $whereArray2['sales_amount'] = $row->amt;
        if (count($dbresults2)>0) 
        {            
          // the record exists. update it            
            $updated  = DB::update("UPDATE cron_reports SET sales_count = :sales_count,sales_amount= :sales_amount  WHERE report_date = :report_date AND merchant_number = :merchant_number",$whereArray2);
        } else 
        {
            // the record does not exists. insert it
            $sql = "INSERT INTO cron_reports (merchant_number,report_date,sales_count,sales_amount) ";
            $sql .= "VALUES(:merchant_number,:report_date,:sales_count,:sales_amount)";
            if(!DB::insert($sql,$whereArray2))
            {
                Log::debug("Stripe add to cron reports: Error while adding sales data for $udate and merchant ".$row->merchantmd5id);
            }
        }        
      }
      
  }
  
  //get charge back and charge back count then insert into cron_reports
  $whereArray = array();
  $select = "SELECT	id,count(id) as chargeback_count,date,merchantmd5id,sum(amount) as amt FROM	stripetransactions ";
	$select .= "WHERE transactiontype like '%chargeback%' and date between :from_date and :to_date	GROUP BY merchantmd5id 	ORDER BY merchantmd5id  ";
  $whereArray['from_date'] = $from_date;
  $whereArray['to_date'] = $to_date;
  $dbresults = DB::select($select,$whereArray); 
  foreach($dbresults as $row) 
  {
    if (!empty($row->merchantmd5id) && !empty($row->date))
      {
        $whereArray2=array();
        $sql = "SELECT id from cron_reports WHERE report_date = :report_date AND merchant_number = :merchant_number"; // using select instead of replace into because this is faster
        $whereArray2['report_date'] = date("Y-m-d",strtotime($udate));
        $whereArray2['merchant_number'] = $row->merchantmd5id;
        $dbresults2 = DB::select($sql,$whereArray2);      
        $whereArray2['chargebacks_count'] = $row->chargeback_count;
        $whereArray2['chargebacks_amount'] = $row->amt;
        if (count($dbresults2)>0) 
        {            
          // the record exists. update it            
            $updated  = DB::update("UPDATE cron_reports SET chargebacks_count = :chargebacks_count,chargebacks_amount = :chargebacks_amount  WHERE report_date = :report_date AND merchant_number = :merchant_number",$whereArray2);
        } else 
        {
            // the record does not exists. insert it
            $sql = "INSERT INTO cron_reports (merchant_number,report_date,chargebacks_count,chargebacks_amount) ";
            $sql .= "VALUES(:merchant_number,:report_date,:chargebacks_count,:chargebacks_amount)";
            if(!DB::insert($sql,$whereArray2))
            {
                Log::debug("Stripe add to cron reports: Error while adding sales data for $udate and merchant ".$row->merchantmd5id);
            }
        }
      }
  }

}

function get_name($table_name,$key,$value,$field){
  if($value>0){
    $users = DB::table($table_name)->select($field)->where($key,$value)->first();
    if(@$users->$field==""){
      return "N/A";
    } else {
      return @$users->$field;
    }
  } else {
    return "N/A";
  }
}

function get_text($string){
  if($string=="" || $string==null || $string=='null' || $string=='NULL'){
    $string = 'N/A';
  }
  return $string;
}

function get_time_difference_minutes($start_time,$end_time){
  $start_time  = strtotime($start_time);
  $end_time  = strtotime($end_time);
  return round(abs($start_time - $end_time) / 60,2);
}

function get_current_date_time_utc($format){
  return Carbon::now('UTC')->format($format);
}

/*
That it is an implementation of the function money_format for the
platforms that do not it bear.

The function accepts to same string of format accepts for the
original function of the PHP.

(Sorry. my writing in English is very bad)

The function is tested using PHP 5.1.4 in Windows XP
and Apache WebServer.
*/
function money_format2($format, $number)
{
    $regex  = '/%((?:[\^!\-]|\+|\(|\=.)*)([0-9]+)?'.
              '(?:#([0-9]+))?(?:\.([0-9]+))?([in%])/';
    if (setlocale(LC_MONETARY, 0) == 'C') {
        setlocale(LC_MONETARY, '');
    }
    $locale = localeconv();
    preg_match_all($regex, $format, $matches, PREG_SET_ORDER);
    foreach ($matches as $fmatch) {
        $value = floatval($number);
        $flags = array(
            'fillchar'  => preg_match('/\=(.)/', $fmatch[1], $match) ?
                           $match[1] : ' ',
            'nogroup'   => preg_match('/\^/', $fmatch[1]) > 0,
            'usesignal' => preg_match('/\+|\(/', $fmatch[1], $match) ?
                           $match[0] : '+',
            'nosimbol'  => preg_match('/\!/', $fmatch[1]) > 0,
            'isleft'    => preg_match('/\-/', $fmatch[1]) > 0
        );
        $width      = trim($fmatch[2]) ? (int)$fmatch[2] : 0;
        $left       = trim($fmatch[3]) ? (int)$fmatch[3] : 0;
        $right      = trim($fmatch[4]) ? (int)$fmatch[4] : $locale['int_frac_digits'];
        $conversion = $fmatch[5];

        $positive = true;
        if ($value < 0) {
            $positive = false;
            $value  *= -1;
        }
        $letter = $positive ? 'p' : 'n';

        $prefix = $suffix = $cprefix = $csuffix = $signal = '';

        $signal = $positive ? $locale['positive_sign'] : $locale['negative_sign'];
        switch (true) {
            case $locale["{$letter}_sign_posn"] == 1 && $flags['usesignal'] == '+':
                $prefix = $signal;
                break;
            case $locale["{$letter}_sign_posn"] == 2 && $flags['usesignal'] == '+':
                $suffix = $signal;
                break;
            case $locale["{$letter}_sign_posn"] == 3 && $flags['usesignal'] == '+':
                $cprefix = $signal;
                break;
            case $locale["{$letter}_sign_posn"] == 4 && $flags['usesignal'] == '+':
                $csuffix = $signal;
                break;
            case $flags['usesignal'] == '(':
            case $locale["{$letter}_sign_posn"] == 0:
                $prefix = '(';
                $suffix = ')';
                break;
        }
        if (!$flags['nosimbol']) {
            $currency = $cprefix .
                        ($conversion == 'i' ? $locale['int_curr_symbol'] : $locale['currency_symbol']) .
                        $csuffix;
        } else {
            $currency = '';
        }
        $space  = $locale["{$letter}_sep_by_space"] ? ' ' : '';

        $value = number_format($value, $right, $locale['mon_decimal_point'],
                 $flags['nogroup'] ? '' : $locale['mon_thousands_sep']);
        $value = @explode($locale['mon_decimal_point'], $value);

        $n = strlen($prefix) + strlen($currency) + strlen($value[0]);
        if ($left > 0 && $left > $n) {
            $value[0] = str_repeat($flags['fillchar'], $left - $n) . $value[0];
        }
        $value = implode($locale['mon_decimal_point'], $value);
        if ($locale["{$letter}_cs_precedes"]) {
            $value = $prefix . $currency . $space . $value . $suffix;
        } else {
            $value = $prefix . $value . $space . $currency . $suffix;
        }
        if ($width > 0) {
            $value = str_pad($value, $width, $flags['fillchar'], $flags['isleft'] ?
                     STR_PAD_RIGHT : STR_PAD_LEFT);
        }

        $format = str_replace($fmatch[0], $value, $format);
    }
    return $format;
}

function get_usd($number){
  setlocale(LC_MONETARY, 'en_US');
  $money  =  str_replace(' ', '',money_format2('%i', $number));
  return $formated = str_replace("USD","$",$money);
}

/* Generate the strong password.
1:Should have At least one Uppercase letter.
2:At least one Lower case letter.
3:Also,At least one numeric value.
4:And, At least one special character.
5:Must be more than 8 characters long
*/
function generateStrongPassword($length = 9, $add_dashes = false, $available_sets = 'luds'){
	$sets = array();
	if(strpos($available_sets, 'l') !== false)
		$sets[] = 'abcdefghjkmnpqrstuvwxyz';
	if(strpos($available_sets, 'u') !== false)
		$sets[] = 'ABCDEFGHJKMNPQRSTUVWXYZ';
	if(strpos($available_sets, 'd') !== false)
		$sets[] = '23456789';
	if(strpos($available_sets, 's') !== false)
		$sets[] = '!@#$%&*?';
	$all = '';
	$password = '';
	foreach($sets as $set){
		$password .= $set[array_rand(str_split($set))];
		$all .= $set;
	}
	$all = str_split($all);
	for($i = 0; $i < $length - count($sets); $i++)
		$password .= $all[array_rand($all)];
	  $password = str_shuffle($password);
	if(!$add_dashes)
		return $password;
	$dash_len = floor(sqrt($length));
	$dash_str = '';
	while(strlen($password) > $dash_len){
		$dash_str .= substr($password, 0, $dash_len) . '-';
		$password = substr($password, $dash_len);
	}
	$dash_str .= $password;
	return $dash_str;
}

function get_current_date_time_user($format){
  return Carbon::now(Session::get('user_timezone'))->format($format);
}

// function check_permission($url){
//   echo '<pre>';
//   echo $url;
//   print_r(Session::get('permissions'));exit;
//   if(!in_array($url, Session::get('permissions'))){
//     return response()->json(['error' => 'unauthorized','msg'=>'Does Not have permissions to perform this action!'], 401);
//   //  exit;
//   }
// }


function check_valid_format_date_time($dateStr, $format){
    $date = DateTime::createFromFormat($format, $dateStr);
    return $date && ($date->format($format) === $dateStr);
}

function convert_user_to_utc_time($from_format,$to_format,$value){
  $date = Carbon::createFromFormat($from_format, $value, Session::get('user_timezone'));
  $date->setTimezone('UTC');
  return $date->format($to_format);
}

function convert_utc_to_user_time($from_format, $to_format, $value) {
  try {
      $date = Carbon::createFromFormat($from_format, $value, 'UTC');
      $date->setTimezone(Session::get('user_timezone'));
      return $date->format($to_format);
  } catch (\Exception $e) {
      \Log::error('Date conversion error: '.$e->getMessage());
      return $value; // or null, or an error string
  }
}


function quickbook_export_status($value) {
  if ($value == 0) {
    return '<i class="fa fa-times-circle text-danger"></i> Not Exported';
  } else {
    return '<i class="fas fa-check-circle text-success"></i> Exported';
}
}

function limitString($string, $limit = 100) {
    // Return early if the string is already shorter than the limit
    if(strlen($string) < $limit) {
      return nl2br(trim(str_replace(array("\r","\n"), "", strip_tags($string))));
    }

    $regex = "/(.{1,$limit})\b/";
    preg_match($regex, $string, $matches);
    return nl2br(trim(str_replace(array("\r","\n"), "", strip_tags($matches[1]))));
}
function get_client_ip()
{
     $ipaddress = '';
     if (getenv('HTTP_CLIENT_IP'))
         $ipaddress = getenv('HTTP_CLIENT_IP');
     else if(getenv('HTTP_X_FORWARDED_FOR'))
         $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
     else if(getenv('HTTP_X_FORWARDED'))
         $ipaddress = getenv('HTTP_X_FORWARDED');
     else if(getenv('HTTP_FORWARDED_FOR'))
         $ipaddress = getenv('HTTP_FORWARDED_FOR');
     else if(getenv('HTTP_FORWARDED'))
         $ipaddress = getenv('HTTP_FORWARDED');
     else if(getenv('REMOTE_ADDR'))
         $ipaddress = getenv('REMOTE_ADDR');
     else
         $ipaddress = 'UNKNOWN';

     return $ipaddress;
}



function grid_link($row_id,$dialog_id,$text){
  return $link = '<a href="javascript:void(0)" class="edit-grid-row" data-id="'.$row_id.'" data-target="#'.$dialog_id.'" data-toggle="modal" role="button">'.$text.'</a>';
}


/**
 *
 * Get times as option-list.
 *
 * @return string List of times
 */
function get_times( $default = '19:00', $interval = '+30 minutes' ) {

    $output = '';

    $current = strtotime( '00:00' );
    $end = strtotime( '23:59' );

    while( $current <= $end ) {
        $time = date( 'H:i', $current );
        $sel = ( $time == $default ) ? ' selected' : '';

        $output .= "<option value=\"{$time}\"{$sel}>" . date( 'h.i A', $current ) .'</option>';
        $current = strtotime( $interval, $current );
    }

    return $output;
}

function get_formated_words($string,$find,$replace){
    return ucwords(str_replace($find, $replace, $string));
}

function total_records($table_name,$where){
  $count = DB::table($table_name)->where($where)->count();
  return @$count;
}


function get_yes_no($value){
  if($value==0){
    return 'No';
  } else {
    return 'Yes';
  }
}

function get_request_status($value){
  if($value==0){
    return 'Pending';
  } else {
    return 'Approved';
  }
}

function get_user_status($value){
  if($value==0){
    return 'Deactive';
  } else {
    return 'Active';
  }
}

function get_months_name($month){
    $dateObj   = DateTime::createFromFormat('!m', $month);
    $monthName = $dateObj->format('F');
  return $monthName;
}


function get_months_name_dropdown($selected=1){
  $months = "";
  for($month=1;$month<=12;$month++){
    $dateObj   = DateTime::createFromFormat('!m', $month);
    $monthName = $dateObj->format('F');
    if($month==$selected){
      $months .= '<option selected="selected" value="'.$month.'">'.$monthName.'</option>';
    } else {
      $months .= '<option value="'.$month.'">'.$monthName.'</option>';
    }
  }
  return $months;
}




function get_years_dropdown($selected=1){
  $years = "";
  for($year=0;$year<=20;$year++){
    $current_year = $selected+$year;
    if($current_year==$selected){
      $years .= '<option selected="selected" value="'.$current_year.'">'.$current_year.'</option>';
    } else {
      $years .= '<option value="'.$current_year.'">'.$current_year.'</option>';
    }
  }
  return $years;
}

function get_week_days_dropdown($selected='monday'){
  $days = ['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];
  $daysDrop = "";
    foreach ($days as $day) {
      $current_year = $day;
      if($day==$selected){
        $daysDrop .= '<option selected="selected" value="'.$day.'">'.$day.'</option>';
      } else {
        $daysDrop .= '<option value="'.$day.'">'.$day.'</option>';
      }
    }
    return $daysDrop;
}




function get_page_name(){
   $get_url  = stripslashes(explode('App\Http\Controllers', Route::getCurrentRoute()->getActionName())['1']);
   $full_url  = explode('@',$get_url);
   Session::put('full_url', @$get_url);
   Session::put('controller', @$full_url[0]);
   Session::put('action', @$full_url[1]);
}

function get_dropdown($table_name,$key,$value,$field,$selected=0,$order_by=null){
  $array_rows = DB::table($table_name)->select($field)->where($key,$value)->orderBy($field['1'], 'ASC')->get();
  $options  = "";
  foreach ($array_rows as $row) {
    $field_id = $field['0'];
    $field_name = $field['1'];
    if($row->$field_id==$selected){
      $options .= '<option selected="selected" value="'.$row->$field_id.'">'.$row->$field_name.'</option>';
    } else {
      $options .= '<option value="'.$row->$field_id.'">'.$row->$field_name.'</option>';
    }
  }
  return $options;
}

function get_multi_dropdown($table_name,$key,$value,$field,$selected=0,$order_by=null){
  $array_rows = DB::table($table_name);
  $array_rows->select($field);
  if($key!="" && $value!=""){
    $array_rows->where($key,$value);
  }
  $rows = $array_rows->orderBy($field['1'], 'ASC')->get();
  $options  = "";
  $selected_array = explode(",",$selected);
  foreach ($rows as $row) {
    $field_id = $field['0'];
    $field_name = $field['1'];
    if (in_array($row->$field_id,$selected_array)){
      $options .= '<option selected="selected" value="'.$row->$field_id.'">'.$row->$field_name.'</option>';
    } else {
      $options .= '<option value="'.$row->$field_id.'">'.$row->$field_name.'</option>';
    }
  }
  return $options;
}


function get_agents_dropdown($parent_id = 0, $sub_mark = ''){
    $query = DB::table('agents');
    $query->select('id','name','parent_agent')->where(['parent_agent'=>$parent_id]);
    if($query->count() > 0){
      $rows = $query->get();
        foreach($rows as $row){
            echo '<option value="'.$row->id.'">'.$sub_mark.$row->name.'</option>';
            get_agents_dropdown($row->id, $sub_mark.'---');
        }
    }
}

function get_agents_dropdown2($parent_id = 0, $sub_mark = ''){
    $query = DB::table('agents');
    $query->select('id','name','parent_agent')->where(['status'=>'Active','parent_agent'=>$parent_id]);
    if($query->count() > 0){
      $rows = $query->get();
        foreach($rows as $row){
            echo '<option value="'.$row->id.'">'.$sub_mark.$row->name.'</option>';
            get_agents_dropdown($row->id, $sub_mark.'---');
        }
    }
}

//returns a parenthesis around the number if it is negative
function check_negative($number,$decimal=2){
  //check if % sign is included with the number
  // try
  // {    
  //   $percentsymbol = '';
  //   if(strpos($number,'%') !== false)
  //   {
  //     $number = str_replace('%','',$number);
  //     $percentsymbol = '%';    
  //   }
  //   if($number<0){
  //     return "(".number_format(abs($number),$decimal).$percentsymbol.")";
  //   } else {
  //     return number_format($number,$decimal).$percentsymbol;
  //   }
  // }
  // catch(Exception $e)
  // {
  //   return $number;
  // }
}

function get_list_checkbox_array($table_name,$key,$value,$field,$selected=0){
  $array_rows = DB::table($table_name)->select($field)->where($key,$value)->get();
  return $array_rows;
}

function get_settings($field_key){
  $comm_fixed = DB::table('settings')->select('field_value')->where('field_key',$field_key)->first();
  return $comm_fixed->field_value;
}

function set_settings($field_key,$field_value){
  $whereArray = array();
  $whereArray['field_key'] = $field_key;
  $whereArray['field_value'] = $field_value;
  $updated  = DB::update("UPDATE settings SET field_value = :field_value WHERE field_key = :field_key",$whereArray);  
  return $updated;
}


function get_yes_no_dropdown($selected=0){
  $array_rows = array(
    '1'=>'Yes',
    '0'=>'No',
  );
  $options  = "";
  foreach ($array_rows as $key => $value) {
    if($key==$selected){
      $options .= '<option selected="selected" value="'.$key.'">'.$value.'</option>';
    } else {
      $options .= '<option value="'.$key.'">'.$value.'</option>';
    }
  }
  return $options;
}

function get_multi_users_chargebacks($start_date,$end_date){
  /*Multi users sale count from nmi table.*/
  $start_date1 =  convert_user_to_utc_time('Y-m-d H:i:s','Y-m-d H:i:s',$start_date." 00:00:00");
  $end_date1    =  convert_user_to_utc_time('Y-m-d H:i:s','Y-m-d H:i:s',$end_date." 23:59:59");

  $multi_users_qry  = DB::table('nmi_payment_transactions as NPT');
  $multi_users_qry->where('NPT.date','>=',$start_date1);
  $multi_users_qry->where('NPT.date','<=',$end_date1);
  $multi_users_qry->where('NPT.action_type','=','sale');
  $multi_users_qry->where('NPT.status','=','complete');
  $multi_urs  = $multi_users_qry->get();
  $multi_users  = array();
  foreach($multi_urs as $multi_ur){
    $user_date  = convert_utc_to_user_time('Y-m-d H:i:s','Y-m-d H:i:s',$multi_ur->date);
    $year1   = date('Y',strtotime($user_date));
    $month1  = date('m',strtotime($user_date));
    if(isset($multi_users[$multi_ur->merchant_number][$year1][$month1])){
      $multi_users[$multi_ur->merchant_number][$year1][$month1]['sale_count'] = $multi_users[$multi_ur->merchant_number][$year1][$month1]['sale_count']+1;
      $multi_users[$multi_ur->merchant_number][$year1][$month1]['sale_amount'] = $multi_users[$multi_ur->merchant_number][$year1][$month1]['sale_amount']+$multi_ur->amount;
    } else {
      $multi_users[$multi_ur->merchant_number][$year1][$month1]['sale_count'] = 1;
      @$multi_users[$multi_ur->merchant_number][$year1][$month1]['sale_amount'] = $multi_ur->amount;
    }
  }

  /*Multi users Chargeback count from nmi chargeback_adjustments.*/
  $chargeBackqry = DB::table('chargeback_adjustments as CA');
  $chargeBackqry->join('nmi_payment_transactions as NPT','CA.auth_number','=','NPT.authorization_code');
  $chargeBackqry->select('CA.action_date','CA.merchant_number','CA.amount','NPT.username','NPT.authorization_code','NPT.date');
  $chargeBackqry->where('NPT.action_type','=','sale');
  $chargeBackqry->where('NPT.status','=','complete');
  $chargeBackqry->where('CA.action_date','>=',$start_date);
  $chargeBackqry->where('CA.action_date','<=',$end_date);
  $chargeBackqry->where('CA.amount','<',0);
  $chargebacks = $chargeBackqry->orderBy('CA.action_date','DESC')->get();

  $multi_chargebacks  = array();
  foreach($chargebacks as $chargeback){
    $year2   = date('Y',strtotime($chargeback->action_date));
    $month2  = date('m',strtotime($chargeback->action_date));
    if(isset($multi_chargebacks[$chargeback->merchant_number][$year2][@$month1])){
      $multi_chargebacks[$chargeback->merchant_number][$year2][$month2]['chargeback_count'] = $multi_chargebacks[$chargeback->merchant_number][$year2][$month2]['chargeback_count']+1;
      $multi_chargebacks[$chargeback->merchant_number][$year2][$month2]['chargeback_amount'] = $multi_chargebacks[$chargeback->merchant_number][$year2][$month2]['chargeback_amount']+abs($chargeback->amount);
    } else {
      $multi_chargebacks[$chargeback->merchant_number][$year2][$month2]['chargeback_count'] = 1;
      @$multi_chargebacks[$chargeback->merchant_number][$year2][$month2]['chargeback_amount'] = abs($chargeback->amount);
    }
  }
    return array(
      'multi_users'=>$multi_users,
      'multi_chargebacks'=>$multi_chargebacks
    );
}


function reformat_date($date, $from_format = 'd/m/Y h:i:s', $to_format = 'Y-m-d h:i:s') {
    $date_aux = date_create_from_format($from_format, $date);
    return @date_format($date_aux,$to_format);
 }

 function change_date_format($date){
   $newDateTime = date('Y:m:d h:i A', strtotime($date));
   return $newDateTime;
 }


 function ampm_format($hours24_format){
    return date("g:i a", strtotime($hours24_format));
 }

 function get_numerics($str) {
   return preg_replace('/[^0-9]/', '', $str);
 }
 function numericonly($str)
 {
    if (is_numeric($str)) 
    {
        return $str;
    } else 
    {
      return 0;
    }
 }

 function clean($string) {
    $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
    $string = preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
    return preg_replace('/-+/', ' ', $string); // Replaces multiple hyphens with single one.
 }

function timezones_list() {
  $zones_array = array();
  $timestamp = time();
  foreach(timezone_identifiers_list() as $key => $zone) {
    date_default_timezone_set($zone);
    $zones_array[$key]['zone'] = $zone;
    $zones_array[$key]['diff_from_GMT'] = 'UTC/GMT ' . date('P', $timestamp);
  }
  return $zones_array;
}
