<?php
namespace App\Http\Middleware;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use Closure;
class CheckPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next){
      if(Auth::check()){
            if(Session::get('group_id')){
              $controller =   str_replace(array('App\Http\Controllers',"\\",'Controller'),"",Session::get('controller'));
              $action = Session::get('action');
              $url  = $request->path();
              $permissions  = Session::get('permissions');
              if(!$request->ajax()){ 
                if(!in_array($url, $permissions)){
                  return redirect('page_403');
                  exit;
                }
              }
            }
            //date_default_timezone_set('Asia/Kolkata');
      } else {
            return redirect('');
      }
        return $next($request);
    }
}
