<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use App\Models\User;
use App\Models\Merchant;
use App\Models\PaymentRequest;
use Carbon\Carbon;
class UserController extends Controller
{

  public function __construct(Request $r){
      if($r->ajax()){
      } else {
      //  $this->middleware('check_permission');
     }
  }

    public function index(Request $req){
      $page_title ='Users';
      $parent_id  =  (int)$req->id;
      return view('users.index',compact('page_title','parent_id'));
    }

    public function page_403(){
        $page_title = "Access denied";
        return view('page_403', compact('page_title'));
    }

    function logout(){
      Auth::logout();
      return redirect('/login');
    }


public function ajax_grid_data(Request $r){
      $orderable  = ['id','firstname','lastname','email','role','status','id'];
      $orderBy    = "U.".$orderable[$r->order['0']['column']];
      $ordertype  = $r->order['0']['dir'];
      $query = DB::table('users as U');
      $query->leftJoin('roles as R','U.role', '=', 'R.id');
      $query->select('U.*','R.name as rolename');
      $query->where(function($query) use ($r){
            $query->where(function($query) use ($r){
              $query->whereNotIn('U.role', ['3','4']);
              $query->where('U.id', '!=','1');
            });
            if($r->search['value']!=""){
              $v  = $r->search['value'];
                $query->Where(function($query) use ($r,$v){
                  $query->orWhere('U.firstname','LIKE',"%$v%");
                  $query->Orwhere('U.lastname','LIKE',"%$v%");
                  $query->Orwhere('U.email','LIKE',"%$v%");
                  $query->Orwhere('U.status','=',"$v");
                });
            }
      });

        $total_records  = $query->count();
        $data = $query->offset($r->start)->limit($r->length)->orderBy($orderBy,$ordertype)->get();
        // echo '<pre>';
        // print_r($data);exit;
        $rows = array();
        foreach($data as $data){
          $actions  = '';
          $view_url = '';
          if(in_array('users/form',Session::get('permissions'))){
            $actions  .= '<a data-id="'.$data->id.'" href="'.url('users/form/?id=').$data->id.'" class="btn btn-info btn-xs">Edit</a>&nbsp;';
            $view_url = 'users/form/?id=';
          } else if(in_array('users/view',Session::get('permissions'))){
               $actions  .= '<a data-id="'.$data->id.'" href="'.url('users/view/?id=').$data->id.'" class="btn btn-info btn-xs">View Detail</a>&nbsp;&nbsp;';
               $view_url = 'users/view/?id=';
          }
          if(in_array('users/delete',Session::get('permissions'))){
            $actions  .= '&nbsp;<a data-id="'.$data->id.'" href="javascript:void(0)" class="btn btn-danger btn-xs delete-user">Delete</a>';
          }

            $rows[] = array(
              'chk'=>'<input type="checkbox" name="list_records[]" value="'.$data->id.'">',
              'firstname'=>'<a data-id="'.$data->id.'" href="'.url($view_url).$data->id.'" class="">'.$data->firstname.'</a>',
              'lastname'=>$data->lastname,
              'email'=>$data->email,
            //  'role'=>$data->rolename,
              'status'=>$data->status,
              'actions'=>$actions,
            );
        }
        echo json_encode([
          "data"=>$rows,
          "draw"=> $r->draw,
          "recordsFiltered"=> $total_records,
          "recordsTotal"=> $total_records
        ]
        );
    }

    public function form(Request $r){
      $tzlist = timezones_list();
      $roles  = DB::table('roles');
      $roles->whereNotIn('id', [3,4]);
      $roles  = $roles->select('id','name')->get();
        if($r->id>0){
          $row = User::find($r->id);
          if($row->timezone ==  ""){
            $row->timezone  = 'America/New_York';
          }
          $page_title  = "Edit User";
        } else {
          $row = new User;
          $row->password  = generateStrongPassword(8);
          $row->timezone  = 'America/New_York';
          $page_title  = "Add New User";
        }
        return view('users.form', compact('row','roles','tzlist','page_title'))->render();
    }

    public function save(Request $r){
       $this->form_validation($r);
        if($r->id>0){
          $rows = User::find($r->id);
        } else {
          $rows = new User;
        }
        $rows->firstname   = $r->firstname;
        $rows->lastname    = $r->lastname;
        $rows->email       = $r->email;
        $rows->timezone    = $r->timezone;
        $rows->status      = $r->status;
        $rows->role        = $r->role;
        if($r->password!=""){
          $rows->password = md5($r->password);
        }
        if($rows->save()){
          echo 'success';
        } else {
          echo 'Fail';
        }
    }

    public function form_validation($r){
      $rules = [
           'firstname' => 'required|min:2|max:100|',
           'lastname' => 'required|min:2|max:100|',
           'email' => 'required|email|unique:users,email,'.$r->id,
     ];
       if($r->id==0 || ($r->password!="")){
         $rules['password'] = 'required|string|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9]).{8,}$/';
       }
       $messages = [
         'password.regex' => 'Password Should have At least 8 char long,One Uppercase letter,One Lower case letter And One numeric letter.',
       ];
       $r->validate($rules,$messages); 
    }

    public function profile(Request $req){
      $page_title ='Update Profile';
      $profileInfo = User::find(Auth::user()->id);
      if($profileInfo->timezone ==  ""){
        $profileInfo->timezone  = 'UTC';
      }
      $tzlist = timezones_list();
      return view('accounts.profile',compact('page_title','tzlist','profileInfo'));
    }


    public function update_profile(Request $r){
        $this->profile_validation($r);
        $rows = User::find(Auth::user()->id);
        $rows->firstname    = $r->firstname;
        $rows->lastname     = $r->lastname;
        $rows->email        = $r->email;
        //$rows->username     = $r->username;
        $rows->timezone     = $r->timezone;
        if($rows->save()){
          Session::put('user_timezone', $rows->timezone);
          echo json_encode(array('msg'=>'Profile updated Successfully.','status'=>'succ'));
        } else {
          echo 'Fail';
        }
    }

    public function profile_validation($r){
      $rules = [
           'firstname' => 'required|min:2|max:100|',
           'lastname' => 'required|min:2|max:100|',
           'email' => 'required|unique:users,email,'.$r->id,
          // 'username' => 'required|unique:users,username,'.$r->id,
     ];
     $r->validate($rules);
    }

    public function change_password_dialog(Request $req){
      $popup_title  = 'Change Password';
      return view('accounts.change_password', compact('popup_title'))->render();
    }

    public function change_password(Request $req){
      $pass  = md5($req->old_password);
      $check_old_pass = User::where(['id'=>Auth::user()->id,'password'=>$pass])->count();
      if($check_old_pass>0){
        $this->change_password_validation($req);
        $changePass = User::find(Auth::user()->id);
        $changePass->password =  md5($req->password);
        if($changePass->save()){
          echo json_encode(array('status'=>'succ','msg'=>'Your password changed successfully.'));
        }
      } else {
        echo json_encode(array('status'=>'error','msg'=>'Your old password does not match with our record.'));
      }
    }

    public function change_password_validation($r){
       $rules['password'] = 'required';
       $rules['retype_password'] = 'required|same:password';
       $r->validate($rules);
    }

    /*Delete the users.*/
    public function delete(Request $r){
      User::whereIn('id', explode(",",$r->id))->delete();
      echo json_encode(['status'=>'succ','msg'=>'Record Deleted Successfully']);
    }

    public function list_inactive_merchants(Request $req){
      if($req->listMerch=='true'){
        Session::put('list_inactive_merchants', ['Active','Inactive']);
      } else {
        Session::put('list_inactive_merchants', ['Active']);
      }
      echo json_encode(['status'=>'succ','msg'=>'Successfully']);
    }

    public function productlist(Request $r){

     Session::forget('group_id1');
     Session::put('group_id1', [$r->groupid]);
      Session::save();


     echo json_encode(['status'=>'succ','msg'=>'Successfully ']);
     exit;
    }    

    public function list_inactive_agents(Request $req){
      if($req->listAgents=='true'){
        Session::put('list_inactive_agents', ['Active','Inactive']);
      } else {
        Session::put('list_inactive_agents', ['Active']);
      }
      echo json_encode(['status'=>'succ','msg'=>'Successfully']);
    }


}
