<?php
namespace App\Http\Controllers;
use Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\Settings;
use App\User;
use App\Models\InvoiceItem;
use App\Models\Invoice;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class SettingsController extends Controller
{

  public function __construct(){
      $this->middleware('auth');
  }

  public function index(){

    $user_id = Auth::id();

    $page_title = "Settings";
    $tzlist = timezones_list();
	 $all_settings = Settings::get();
   $timezone  = "";
   $data  = array();
   //$data = DB::table('static_pages')->where('page_name','=','terms')->first();
    foreach($all_settings as $settings){
      $settings_array[$settings->field_key] = $settings->field_value;
    }
    return view('settings.index', compact('page_title','settings_array','tzlist','data','timezone'));
  }

  // public function settings($pagename){
  //   $page_title = "Terms of service";
  //   $data = DB::table('static_pages')->where('page_name','=',$pagename)->first();
  //   return view('settings.terms', compact('page_title','data','pagename'));
  // }

  public function save_settings(Request $r)
  {
      // Get 'settings' array or default to an empty array
      $settings = $r->input('settings', []);
  
      // Ensure 'stop_incrementing_invoice_numer' is set
      if (!isset($settings['stop_incrementing_invoice_numer'])) {
          $settings['stop_incrementing_invoice_numer'] = 0;
      }
  
      // Iterate over settings and update database
      foreach ($settings as $key => $value) {
          Settings::where('field_key', $key)->update(['field_value' => $value]);
      }
  
      // Return JSON response
      return response()->json(['status' => 'succ', 'msg' => 'Settings saved successfully']);
  }

function getPricesheet(){
    $rows= PriceSheet::get();
    echo json_encode(array('status'=>'succ','res'=>$rows));

}

public function savesheet(Request $r){

    
    $this->form_validation_price($r); 


    $editsheetid = $r->editsheetid;  
    

    
    if($editsheetid!=''){
      $rows= PriceSheet::find($editsheetid);
      PriceSheetItems::where('sheet_id', '=', $editsheetid)->delete();
    }else{
      // check sheet name already exist or not
      $checksheet = PriceSheet::where('title',trim($r->title))->first();
      if(!empty($checksheet)){
        echo json_encode(array('status'=>'error','msg'=>'Price sheet name is already exist.'));
        exit;
      }

      $rows = new PriceSheet;
    }

    // check array has duplicate value or not
    
    if ( count( $r->discount_periods ) !== count( array_unique( $r->discount_periods ) ) ){
      echo json_encode(array('status'=>'error','msg'=>'Duplicate discount period is not allowed on the same price sheet.'));
      exit;
    } 
    $rows->user_id   = Auth::id();
    $rows->title    = $r->title;
    $rows->sheet_type       = $r->sheet_type;
    $rows->created_at    = date("Y-m-d");
    if($rows->save()){

      $price_sheet_id=$rows->id;

      $from_qty=$r->from_qty;

      if(!empty($from_qty)){
        $discount_periods=$r->discount_periods;
        $to_qty=$r->to_qty;
        $price=$r->price;
        $cost=$r->cost;
        $wire_price=$r->wire_price;
        $wire_cost=$r->wire_cost;
        $i=0;
          foreach($from_qty as $item){
              $items=new PriceSheetItems;
              $items->sheet_id   = $price_sheet_id;
              $items->from_qty    = $item;
              $items->to_qty       = $to_qty[$i];
              $items->discount_periods    = $discount_periods[$i];
              $items->price   = $price[$i];
              $items->cost    = $cost[$i];
              $items->wire_price       = $wire_price[$i];
              $items->wire_cost    = $wire_cost[$i];
              $items->save();
              $i++;
          }          
      }

          if($editsheetid!=''){
            echo json_encode(array('status'=>'update','msg'=>'Your price sheet successfully updated.','title'=>$r->title,'price_sheet_id'=>$editsheetid));
          }else{
            $sheetarray=array();
            $sheetarray['title']=$r->title;
            $sheetarray['price_sheet_id']=$price_sheet_id;
            echo json_encode(array('status'=>'succ','msg'=>'Your price sheet successfully created.','title'=>$r->title,'price_sheet_id'=>$price_sheet_id));  
          }
          
        } else {
          echo json_encode(array('status'=>'error','msg'=>'Technical issue.'));
        }
}

public function form_validation($r){
  $rules['settings[site_title]'] = 'required';
   $r->validate($rules);
}

public function form_validation_price($r){
        $rules = [
             'title' => 'required',
/*             'from_qty' => 'required',
             'price' => 'required',
             'cost' => 'required'
*/       ];
       $r->validate($rules);
    }

public function getExistsheet(Request $r){
  $sheetid=$r->sheet_id;

  $sheet = PriceSheet::where('id',$sheetid)->first();


  $sheetarray=array();
  if(!empty($sheet)!=0){
      $sheetarray['name']=$sheet['title'];
      $sheetarray['sheet_type']=$sheet['sheet_type'];

      //PriceSheetItems

      $items = PriceSheetItems::where('sheet_id',$sheetid)->get();
      if(!empty($items)){
        $sheetarray['items']=$items;
      }else{
        $sheetarray['items']=array();        
      }
  }

    echo json_encode(array('status'=>'succ','result'=>$sheetarray));
    
}

public function updateMerchant(Request $r){

  $marchants = json_decode($r->merchantlist,true);
  $sheetid = $r->sheetid;

  $isassign=0;
  if(count($marchants[0])!=0){
      foreach($marchants[0] as $mid){

        $pricedata = PriceSheet::whereRaw("FIND_IN_SET($mid,merchant_id)")->where('id', '!=',  $sheetid)->first();
        if(!empty($pricedata)){
          $isassign=1;
          break;
        }
      }
  }


  if($isassign==1){
      echo json_encode(array('status'=>'error','msg'=>'Merchant is already assign to pricesheet.'));
      exit;
  }

  $marchantslist=implode(",", $marchants[0]);
  
  $UpdateSheet = PriceSheet::where('id', '=',  $sheetid)->first();
  $UpdateSheet->merchant_id = $marchantslist;
  $UpdateSheet->save();

  echo json_encode(array('status'=>'succ','msg'=>'Merchant has been update successfully'));
}

public function removeSheet(Request $r){

  PriceSheet::where('id','=',$r->row_id)->delete();
  PriceSheetItems::where('sheet_id', '=', $r->row_id)->delete(); 
  echo json_encode(array('status'=>'succ','msg'=>'Price sheet has been successfully deleted'));
  
}


}
