<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use App\Models\User;
use App\Models\Group;
use App\Models\Privilege;
use App\Models\Permission;
use App\Models\Role;
use Carbon\Carbon;
class RoleController extends Controller
{

    public function __construct(){
        $this->middleware('auth');
    }

    public function index(Request $req){
      $page_title ='Roles';
      return view('roles.index',compact('page_title'));
    }


public function ajax_grid_data(Request $r){
      $orderable  = ['id','id','name','id'];
      $orderBy    = $orderable[$r->order['0']['column']];
      $ordertype  = $r->order['0']['dir'];
      $query = DB::table('roles');
      if($r->search['value']!=""){
          $v  = $r->search['value'];
          $query->where('name','LIKE',"%$v%");
      }

        $total_records  = $query->count();
        $data = $query->offset($r->start)->limit($r->length)->orderBy($orderBy,$ordertype)->get();
        $rows = array();
        foreach($data as $data){
          if ($data->id == 1)  
          {
          $rows[] = array(
              'chk'=>'<input disabled type="checkbox" name="list_records[]" value="'.$data->id.'">',
              'id'=>$data->id,
              'name'=>$data->name,
              'actions'=>'<button data-id="'.$data->id.'" href="#" class="btn btn-info btn-xs" disabled>Edit</button>&nbsp;&nbsp;<button data-id="'.$data->id.'" class="btn btn-danger btn-xs" disabled>Delete</button>',

            );
           
          } else
          {
          $rows[] = array(
              'chk'=>'<input type="checkbox" name="list_records[]" value="'.$data->id.'">',
              'id'=>$data->id,
              'name'=>'<a data-id="'.$data->id.'" href="'.url('roles/form/?id=').$data->id.'" class="">'.$data->name.'</a>',
              'actions'=>'<a data-id="'.$data->id.'" href="'.url('roles/form/?id=').$data->id.'" class="btn btn-info btn-xs">Edit</a>&nbsp;&nbsp;<a data-id="'.$data->id.'" href="javascript:void(0)" class="btn btn-danger btn-xs delete-role">Delete</a>',

            );
          }
        }
        echo json_encode([
          "data"=>$rows,
          "draw"=> $r->draw,
          "recordsFiltered"=> $total_records,
          "recordsTotal"=> $total_records
        ]
        );
    }

    public function form(Request $r){
      $sel_permissions  = array();
      $sel_privileges   = array();
      $privileges         = Privilege::select('id', 'name','route_name')->where('type', 'privileges')->whereIn('status',['active'])->get();
      $permissions        = Permission::where('permission_type','permissions')->get();
      if($r->id>0){
        $page_title  = "Edit Role";
        $group_detail       = Role::find($r->id);
        if($group_detail->permissions!=""){
          $sel_permissions    =   json_decode($group_detail->permissions,true);
        }
        if($group_detail->privileges!=""){
          $sel_privileges     =   json_decode($group_detail->privileges,true);
        }
      } else {
        $page_title  = "Add New Role";
        $group_detail       = new Role;
      }
      return view('roles.form', compact('page_title','group_detail','sel_permissions','sel_privileges','permissions','privileges'))->render();
    }

    public function save(Request $r){
      $this->form_validation($r);
      if($r->id>0){
        $group = Role::find($r->id);
      } else {
        $group = New Role;
      }
      $group->name          = $r->name;

      if($r->permissions!=""){
        $selected_permissions = json_encode(array_filter($r->permissions, 'strlen'));
        $group->permissions   = $selected_permissions;
      }
      if($r->privileges_route!=""){
        $selected_privileges  = json_encode(array_filter($r->privileges_route, 'strlen'));
        $group->privileges    = $selected_privileges;
      }
      $group->status        = 1;
      if($group->save()){
        echo 'success';
      } else {
        echo 'Fail';
      }
    }

    public function form_validation($r){
        $rules = [
             'name' => 'required',
       ];
       $customMessages = [
           'name.required' => 'Please enter the value in name'
       ];
       $r->validate($rules,$customMessages);
    }


    /*Delete the users.*/
    public function delete(Request $r){
      $not_deleteable = array();
      foreach (explode(',',$r->id) as $value) {
        $users = DB::table('users');
        $users->where(['role'=>$value]);
        $users->select('name','id');
         if($users->count()==0){
           if(!in_array($value,['1','2','3','4'])){
             Role::where('id','=',$value)->delete();
           } else {
             $not_deleteable[]  = $value;
           }
         } else {
           $not_deleteable[]  = $value;
         }
      }
      if(count($not_deleteable)>0){
        $roles  = Role::whereIn('id', $not_deleteable)->pluck('name')->toArray();
        $msg  = "You cannot delete roles if a user is assigned to this role. The role you selected has one or more users assigned";
        echo json_encode(['status'=>'error','msg'=>$msg]);
      } else {
        $roles  = array();
        $msg  = 'Records Deleted Successfully';
        echo json_encode(['status'=>'succ','msg'=>$msg]);
      }
    }
}
