<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use App\Models\User;
use App\Models\Merchant;
use App\Models\Agent;
use App\Models\Invoice;
use App\Models\InvoiceItem;
use App\Models\PaymentRequest;
use App\Models\InvoicePayment;
use App\Models\AccountingTemplate;
use App\Models\AccountingTemplateMerchant;
use App\Models\AccountingTemplateAgent;
use App\Models\InvItem;
use Carbon\Carbon;
use View;
use PDF;
use Spatie\Activitylog\Models\Activity;
use App\Models\InvoiceLog;
use Response;
use PHPMailer\PHPMailer\PHPMailer;


class InvoicePublicController extends Controller
{

  public function __construct()
  {
    //check if user is already logged in
    //$this->middleware('guest');
  }

   public function payinvoice(Request $r)
   {  
        $publicpayid = $r->id;
        $page_title = 'Pay Invoice';
        $balance = 0;
        //if publicpayid is not set flash public_pay_error session then load payment_public view
        if(!isset($publicpayid))
        {
            Session::flash('public_pay_error', 'Invalid Payment Request');   
            return view('invoices.payment_public',compact('page_title', 'publicpayid','balance'));         
        }
        //select from invoices where publicpay_id = $publicpayid and publicpayid_expires has not passed
        $invoice = Invoice::where('publicpay_id', $publicpayid)->where('publicpayid_expires', '>', Carbon::now())->first();
        //if invoice is not found flash public_pay_error session then load payment_public view
        if(!$invoice)
        {
            Session::flash('public_pay_error', 'The payment request has expired or is invalid.');   
            return view('invoices.payment_public',compact('page_title','publicpayid','balance'));         
        }
        //if invoice is found get invoice number and balance
        $invoicenum = $invoice->invoice_id;
        $paid = $invoice->balance ?? 0;
        $balance = $invoice->amount - $paid;
        return view('invoices.payment_public',compact('page_title','publicpayid','invoicenum','balance'));
   } 

   public function pay_with_achmodal(Request $r)
   {
        
        $jsonachinfo = array();
        $response = array(); 
        $response['status'] = '2';
        $page_title = 'Pay with ACH';        
        $invoiceid = 0;  
        $publicpayid = $r->publicpayid ?? 0;              
        $invoice = Invoice::where('publicpay_id', $publicpayid)->where('publicpayid_expires', '>', Carbon::now())->first();
        if (!$invoice)
        {
            $response['status'] = '0';
            $response['message'] = 'The payment request has expired or is invalid.';
            return Response::json($response);
        }
        $paid = $invoice->balance ?? 0;
        $amount = $invoice->amount - $paid;
        if ($invoice->usertype == '2')
        {
            $merchant = Merchant::find($invoice->merchant);
            $jsonachinfo = json_decode($merchant->achinfo);
            $recordtype = 'merchant';
            $recordid = $invoice->merchant;
            $response['status'] = '1';
            $invoiceid = $r->invoiceid;
        } else if ($invoice->usertype == '1')
        {
            $agent = Agent::find($invoice->merchant);
            $jsonachinfo = json_decode($agent->achinfo);
            $recordtype = 'agent';
            $recordid = $invoice->merchant;
            $response['status'] = '1';
            $invoiceid = $r->invoiceid;
        }    
        $response['html'] = view('ach.paywithach_public',compact('jsonachinfo','recordtype','recordid','page_title','amount','invoiceid','publicpayid'))->render();
        return Response::json($response);        
    }   
  
}
