<?php

namespace App\Http\Controllers;

use App\Models\InvItem;
use App\Models\InvItemPrice;
use App\Models\Product;
use Illuminate\Http\Request;

class InvoiceItemController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct(){

        $this->middleware('auth');
    }

    public function index()
    {
        $page_title = 'Invoice Items';

        return view('invoice-items.index', compact('page_title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function save(Request $request)
    {
        $request->validate([
            'item' => 'required',
        ]);
        $inv_item = new InvItem();
        $inv_item->item =  $request->item;
        $inv_item->type = $request->type;
        $inv_item->quantity  = $request->quantity;
        $inv_item->description  = $request->description;

            $inv_item->price  = $request->fixed_price;
            $inv_item->save();
            $success = true;
        if ($success) {            
            //save invoice item to products table - disabled for now. Rober changed his mind
            /*
            $product = new Product();
            $product->description = $request->item;
            $product->type = 1;
            $product->free_source = 'Invoice_Item';
            $product->group_id = 0;
            $product->invoice_item_id = $inv_item->id;
            $product->name = "formula_invitem_".$inv_item->id;
            $product->save();
            **/
            return response()->json(['status' => 200, 'message' => 'Invoice Item Added Successfully!', 'data' => []]);
        } else {
            return response()->json(['status' => 500, 'message' => 'Something went wrong', 'data' => []]);
        }
    }
    /**
     * List the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function get_list()
    {
        return InvItem::with('prices')->get();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $request->validate([
            'item' => 'required',
        ]);
        $inv_item = InvItem::find($request->id);
        $inv_item->item =  $request->item;
        $inv_item->type = $request->type;
        $inv_item->quantity  = $request->quantity;
        $inv_item->price  = $request->fixed_price;
        $inv_item->description  = $request->description;
        $inv_item->save();
        $success = true;
        
        if ($success) {
            return response()->json(['status' => 200, 'message' => 'Invoice Item Updated Successfully!']);
        } else {
            return response()->json(['status' => 500, 'message' => 'Something went wrong', 'data' => []]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $r)
    {
        $del_item = InvItem::where('id', $r->id)->delete();
        InvItemPrice::where('inv_item_id', $r->id)->delete();
        //delete from products table

        if ($del_item) {
            echo json_encode(['status' => 'succ']);
        } else {
            echo json_encode(['status' => 'fail']);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function getInvitemDetails(Request $r)
    {
        return InvItem::where('id', $r->invoice_item_id)->with('prices')->first();
    }
}
