<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use App\Models\User;
use App\Models\Merchant;
use App\Models\Agent;
use App\Models\Invoice;
use App\Models\InvoiceItem;
use App\Models\PaymentRequest;
use App\Models\InvoicePayment;
use App\Models\AccountingTemplate;
use App\Models\AccountingTemplateMerchant;
use App\Models\AccountingTemplateAgent;
use App\Models\InvItem;
use Carbon\Carbon;
use View;
use PDF;
use Spatie\Activitylog\Models\Activity;
use App\Models\InvoiceLog;
use Response;
use PHPMailer\PHPMailer\PHPMailer;


class InvoiceController extends Controller
{

  public function __construct(){
     //  if($r->ajax()){
     //  } else {
     //    $this->middleware('check_permission');
     // }     
     $this->middleware('auth'); 
  }

    public function index(Request $req){
      //print all session data
      $page_title ='Invoices';
      $customers = DB::table('customers')->pluck('display_name','qb_id')->toArray();
      $inv_items  = InvItem::orderBy('item')->get();    
      $lastrecrod=  Invoice::orderBy('id', 'desc')->where('type',"=","1")->first();
      $invoiceid="101";
      if(!empty($lastrecrod)){
          $invoiceid=$lastrecrod['invoice_id']+1;
      }
      return view('invoices.index',compact('page_title','customers','invoiceid', 'inv_items'));
    }

    public function ajax_grid_data(Request $r){
      // dd('ajaxgrid');
           $orderable  = ['id','invoicedate','invoice_id','merchant','amount','balance','id','usertype'];
           $orderBy    = "U.".$orderable[$r->order['0']['column']];
           $ordertype  = $r->order['0']['dir'];
           $query = DB::table('invoices as U');
      
           if($r->search['value']!=""){
                   $v  = $r->search['value'];
                     $query->Where(function($query) use ($r,$v){
                       $query->orWhere('U.invoice_id','LIKE',"%$v%");
                       $query->orWhere('U.merchant_name','LIKE',"%$v%");
                       $query->orWhere('U.amount','LIKE',"%$v%");
                     });
                 }
           $total_records  = $query->count();
           $data = $query->offset($r->start)->limit($r->length)->where('type',"=","1")->orderBy($orderBy,$ordertype)->get();
         
           $rows = array();
           foreach($data as $data){
               $actions  = '';
               $view_url = '';
               if(in_array('users/form',Session::get('permissions'))){
                 $actions  .= '<a data-id="'.$data->id.'" href="'.url('users/form/?id=').$data->id.'" class="btn btn-info btn-xs">Edit</a>&nbsp;';
                 $view_url = 'users/form/?id=';
               } else if(in_array('users/view',Session::get('permissions'))){
                    $actions  .= '<a data-id="'.$data->id.'" href="'.url('users/view/?id=').$data->id.'" class="btn btn-info btn-xs">View Detail</a>&nbsp;&nbsp;';
                    $view_url = 'users/view/?id=';
               }
               if(in_array('users/delete',Session::get('permissions'))){
                 $actions  .= '&nbsp;<a data-id="'.$data->id.'" href="javascript:void(0)" class="btn btn-danger btn-xs delete-user">Delete</a>';
               }          
     
               $bal = ($data->balance)?$data->balance:0;
               $pbal=($data->balance)?$data->balance:0;
               if($data->amount!=''){
                 $bal = $data->amount-$bal;
               }
                  $email = '';//'<a  data-invoiceid="'.$data->invoice_id.'" href="javascript:void(0)" data-toggle="modal" data-balance="'.number_format((float)$bal, 2, '.', '').'" data-target="#invoice_email" class="btn btn-sm btn-info" data-id="'.$data->id.'">Email</a>';
                  $print = '';//'<a data-id="'.$data->id.'"  target="_blank" href="'.url('invoices/invoicedetail/')."/".$data->id.'" class="btn btn-sm btn-info">Print</a>&nbsp;';                          
                  $apply_payment = '';//'<a  data-id="'.$data->id.'" alt="'.$data->invoice_id.'" href="javascript:void(0)" data-toggle="modal" data-balance="'.number_format((float)$bal, 2, '.', '').'" data-target="#invoice_payments" class="btn btn-sm btn-info" data-id="'.$data->id.'">Record Payment</a>';             
                  $idate=convert_utc_to_user_time('Y-m-d','m/d/Y',$data->invoicedate);
                   
                   $rows[] = array(
                   'chk'=>'<input type="checkbox" name="list_records[]" value="'.$data->id.'" alt="'.$data->invoice_id.'" data-export="'.$data->qb_export_status.'">',
                   'invoicedate'=>$idate,
                   'invoice_id'=>"<a href='javascript:void(0)' title='update' class='viewinvoice' alt='".$data->id."' >#".$data->invoice_id.'</a>',
                   'merchant'=>''.@$data->merchant_name.'</a>',
                   'amount'=>($data->amount)?number_format((float)$data->amount, 2, '.', ''):0,
                   'balance'=>'<span id="bal'.$data->id.'">'.number_format((float)$bal, 2, '.', '').'</span>',
                   'action'=>'<span style="color:red;width:70px;float:left;" id="amt'.$data->id.'">'.number_format((float)$pbal, 2, '.', '').'</span>  '.$apply_payment.'&nbsp;'.$print.'&nbsp;'.$email,
                   'export_qb'=>quickbook_export_status($data->qb_export_status),
                 );
             }
             echo json_encode([
               "data"=>$rows,
               "draw"=> $r->draw,
               "recordsFiltered"=> $total_records,
               "recordsTotal"=> $total_records
             ]
             );
         }
     
         public function form(Request $r){
           $tzlist = timezones_list();
           $roles  = DB::table('roles');
           $roles->whereNotIn('id', [3,4]);
           $roles  = $roles->select('id','name')->get();
             if($r->id>0){
               $row = User::find($r->id);
               if($row->timezone ==  ""){
                 $row->timezone  = 'America/New_York';
               }
               $page_title  = "Edit User";
             } else {
               $row = new User;
               $row->password  = generateStrongPassword(8);
               $row->timezone  = 'America/New_York';
               $page_title  = "Add New User";
             }
             return view('users.form', compact('row','roles','tzlist','page_title'))->render();
         }
     
         public function save(Request $r){
            $this->form_validation($r);
             if($r->id>0){
               $rows = User::find($r->id);
             } else {
               $rows = new User;
             }
             $rows->firstname   = $r->firstname;
             $rows->lastname    = $r->lastname;
             $rows->email       = $r->email;
             $rows->timezone    = $r->timezone;
             $rows->status      = $r->status;
             $rows->role        = $r->role;
             if($r->password!=""){
               $rows->password = md5($r->password);
             }
             if($rows->save()){
               echo 'success';
             } else {
               echo 'Fail';
             }
         }
     
         public function form_validation($r){
           $rules = [
                'firstname' => 'required|min:2|max:100|',
                'lastname' => 'required|min:2|max:100|',
                'email' => 'required|email|unique:users,email,'.$r->id,
          ];
            if($r->id==0 || ($r->password!="")){
              $rules['password'] = 'required|string|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9]).{8,}$/';
            }
            $messages = [
              'password.regex' => 'Password Should have At least 8 char long,One Uppercase letter,One Lower case letter And One numeric letter.',
            ];
            $r->validate($rules,$messages); 
         }
     

    public function payinvoiceach(Request $r){
      
      $response = array();
      $invoice = Invoice::find($r->recordid);
      $response['status'] = '1';
      $achinfo = null;
      $account_number = "";
      $routing_number = "";
      $amount = $r->amount;
      $account_type = "";
      if ($invoice != null)
      {
        if ($invoice->usertype == 1) 
        {
          $clientdetails = Agent::find($invoice->merchant)->select('achinfo','name','address','city','state','zip')->first(); 
          $achinfo = json_decode(Agent::find($invoice->merchant)->achinfo);
        }
        if ($invoice->usertype == 2) 
        {
          //get merchant ach info
          $achinfo = json_decode(Merchant::find($invoice->merchant)->achinfo);         
        }
        if ($achinfo != null && isset($r->ach_pay_index))
        {
            //get ach details from $achinfo object using $r->achid          
            foreach ($achinfo as $row) 
            {
              if ($row->row_uniqueid == $r->ach_pay_index)
              {
                $account_number = $row->account_number;
                $routing_number = $row->routing_number;
                $account_type = $row->account_type;
                break;
              }
            }
            //check if ach info is found
            if (strlen($account_number) > 0 && strlen($routing_number)>0 && $amount > 0) 
            {              
              $paydata = array(
                "transaction_type"=> "DEBIT",
                "account_type"=> $account_type,
                "billing_first_name"=> "John",
                "billing_last_name"=> "Test",
                "billing_address"=> "123 maple dr",
                "billing_city"=> "oak",
                "billing_state"=> "ny",
                "billing_zip"=> "11514",
                "billing_country"=> "US",
                "billing_phone"=> "5555555555",
                "account_number"=> "000000001",
                "routing_number"=> "000000015",
                "amount"=> "1.00",
                "billing_ip"=> "111.111.111.111",
                "callback_url"=>"https://www.example-store.com/url"
              );


            } else 
            {
              $response['status'] = '0';
              $response['message'] = 'Invalid ACH information or zero amount specified';
            }          
        } else {
          $response['status'] = '0';
          $response['message'] = 'The selected ACH account is not found';
        }

      } else {
        $response['status'] = '0';
        $response['message'] = 'Invoice not found';
      }
      
      //return jason formatted response
      return Response::json($response);  
    }

    public function invoice_email(Request $r)
    {
      $page_title = 'Email Invoice ' . $r->invoiceid;
      $email = "";
      $invoice = Invoice::find($r->recordid);
      $balance = $r->balance;
      if ($invoice != null)
      {
        if ($invoice->usertype == 1) 
        {
          $agent = Agent::find($invoice->merchant);
          if ($agent != null) 
          {           
            $search_query = DB::table('users')->select('users.email')->join('agents', 'users.id', '=', 'agents.user_id')->where('agents.id', '=', $agent->id)->first();
            $email = $search_query->email;        
          }
        }
        if ($invoice->usertype == 2) 
        {
          $merchant = Merchant::find($invoice->merchant);
          if ($merchant != null) 
          {           
            $search_query = DB::table('users')->select('users.email')->join('merchants', 'users.id', '=', 'merchants.user_id')->where('merchants.id', '=', $merchant->id)->first();
            $email =  $search_query->email;        
          }         
        }
      } 
      return view('invoices.invoice_email',compact('page_title','email','r'));
    }

    public function send_email(Request $r)
    {      
      $response = array();
      $emailaddresses = array();     
      $emailaddresses = explode(',', $r->email);
      $invoice = Invoice::find($r->recordid);
      $balance = $r->balance;
      $response['status'] = '1';
      $html = "";
      $publicpayid = "";
      if ($invoice != null)
      {
        //validate email
        if (count($emailaddresses) > 0 && filter_var($emailaddresses[0], FILTER_VALIDATE_EMAIL) && count($emailaddresses) < 10) 
        {
          //if invoice publicpay_id is not set then generate one
          if ($invoice->publicpay_id == null) 
          {
            $publicpayid=md5(uniqid(rand(), true));            
          } else 
          {
            $publicpayid = $invoice->publicpay_id;
          }
          //render invoice html view
          $html = view('invoices.emailbody',compact('r','invoice','publicpayid'))->render();
          //get attachment from public path
          $attachment = public_path('cbstreaminvoice.pdf');
          if ($this->send_mailer($html,$emailaddresses, 'Invoice ' .$invoice->invoice_id.' due from CB Steam Live', $attachment)) 
          {
            //update invoices table publicpay_id column with md5 hash of a cryptographically secure string and set publicpayid_expires to 4 days from now using carbon
            $invoice->publicpay_id = $publicpayid;
            $invoice->publicpayid_expires = Carbon::now()->addDays(4);
            $invoice->save();
            $response['status'] = '1';
            $response['message'] = 'Email sent successfully';
          } else 
          {
            $response['status'] = '0';
            $response['message'] = 'Email sending failed';
          }
        } else 
        {
          $response['status'] = '0';
          $response['message'] = 'Invalid email address or too many email addresses specified';
        }
      }  else 
      {
        $response['status'] = '0';
        $response['message'] = 'Invoice not found';
      }     
      
      //return jason formatted response
      return Response::json($response);
      }


    
    public function create_invoice_promo(Request $req){
      $page_title = 'Invoices';
      $parent_id  =  (int)$req->id;
      $merchants  = Merchant::select('id', 'merchant_number', 'name')->get();
      $agents  = Agent::select('id', 'name')->get();
      $templates  = AccountingTemplate::select('*')->get();
      $inv_items  = InvItem::get();

      $lastrecrod = Invoice::orderBy('id', 'desc')->where('type', "=", "1")->first();

      $invoiceid = "101";
      if (!empty($lastrecrod)) {
        $invoiceid = $lastrecrod['invoice_id'] + 1;
      }
      $promo_form = $req->promo_form;
      $invoice_items_promo = array_values(array_filter($req->invoice_items_promo));
      $qty_promo = array_values(array_filter($req->qty_promo));
      $merchantNames = array_values(array_filter($req->merchantName_promo)); //merrick
      $merchantName_promo = $req->invoiceName_promo;
      //update $merchantName_promo array to include merchant name from $merchantNames array
      if(is_array($merchantNames) && count($merchantNames)>0){
        foreach($merchantNames as $key=>$val){
          $merchantName_promo[$key] = $merchantName_promo[$key] . " " . $val;
        }
      }

      //$invoiceName_promo = $req->invoiceName_promo;
      
      // auto add
      $auto_invoice_items = InvItem::where('is_auto_all_invoices', 1)->get()->toArray();
      foreach($auto_invoice_items as $val){
        if(!in_array($val['id'],$invoice_items_promo)){
          array_push($invoice_items_promo,$val['id']);
          array_push($qty_promo,$val['quantity']);
          if(is_array($merchantName_promo) && count($merchantName_promo)>0)
          array_push($merchantName_promo,$val['item']);
        }
      }

      
      return view('invoices.index', compact('page_title', 'parent_id', 'merchants', 'templates', 'invoiceid', 'agents', 'inv_items', 'promo_form', 'invoice_items_promo', 'qty_promo', 'merchantName_promo'));
    }



    

    public function invoice_payments(Request $req){
      $popup_title  = 'Payments';
      $invoice_id = $req->invoice_id;
      $balance = $req->balance;
      $payments     = InvoicePayment::where(['invoice_id'=>$req->invoice_id])->get();
      return view('invoices.invoice_payments', compact('popup_title','payments','invoice_id','balance'))->render();
    }

    public function invoice_payments_history(Request $req){
      $popup_title  = 'Payments';
      $invoice_id = $req->invoice_id;
      $balance = $req->balance;
      $payments     = InvoicePayment::where(['invoice_id'=>$req->invoice_id])->get();
      return view('invoices.invoice_payments_history', compact('popup_title','payments','invoice_id','balance'))->render();
    }

    public function minvoice_payments(Request $req){
      $popup_title  = 'Payments';
      $id = $req->id;
      $iid = $req->iid;

      $payments     = InvoicePayment::whereIn('invoice_id', explode(",",$id))->get();


      return view('invoices.minvoice_payments', compact('popup_title','id','iid','payments'))->render();
    }

    public function add_payment_form_validation($r){
        $rules = [
            'amount'        => 'required',
       ];
       $r->validate($rules); 
    }


    public function add_invoice_payment(Request $req){
         //$this->add_payment_form_validation($req);
         //echo convert_user_to_utc_time('m/d/Y','Y-m-d',$req->date);exit;

              if(trim($req->amount)=="" || trim($req->amount)<=0 || trim($req->amount)<=0.00){

                echo json_encode(['status'=>'error','data'=>'','msg'=>'Please enter amount','total'=>'0','id'=>'0']);
                exit;
              }

              $form = new InvoicePayment;
              $form->note           =  $req->note;
              $form->user_id        =  Auth::user()->id;
              $form->payment_amount =  $req->amount;
              $form->payment_date   =  convert_user_to_utc_time('m/d/Y','Y-m-d',$req->date);
              $form->created_at   =  date("Y-m-d H:i:s");
              $form->updated_at   =  date("Y-m-d H:i:s");
              $form->invoice_id     =  $req->invoice_id;
              $form->save();
              $invoice = Invoice::find($req->invoice_id);
              $tempinv = Invoice::where(['id'=>$req->invoice_id])->first();
              // echo '<pre>';
              // print_r($invoice);
              // print_r($tempinv);
              // exit;
              if(!empty($tempinv)){
                $bal=$tempinv['balance'];
              }
              $invoice->balance = ($req->amount+$bal);
              $invoice->save();
              // exit;
              // echo 'manojTesyt';exit;
              $this->storeInvoiceLogs();              

              $newString = '<div class="row">
                <label for="affiliates" class="col-md-2 radio-inline">'.date("m/d/Y",strtotime($form->payment_date)).'</label>
                <label for="affiliates" class="col-md-2 radio-inline text-right">$'.number_format((float)$req->amount, 2, '.', '').'</label>
                <label for="affiliates" class="col-md-4 radio-inline">'.$req->note.'</label>
                <label for="affiliates" class="col-md-2 radio-inline"><a class="remove-invoice-payment btn btn-danger btn-sm" href="javascript:void(0)"  data-id="'.$form->id.'">Remove</a></label>
              </div>';
        echo json_encode(['status'=>'succ','data'=>$newString,'msg'=>'Payment has been update successfully','total'=>number_format((float)$req->amount+$bal, 2, '.', ''),'id'=>$req->invoice_id]);
    }

    public function add_minvoice_payment(Request $req){

            $invoices=$req->invoice_id;
            $amount=$req->amount;
            $payment_date=$req->date;
            $note=$req->note;

            // echo '<pre>';
            // print_r($invoices);exit;
                $iserror=0;
            if(!empty($amount)){
              foreach($amount as $amt){

                  if(trim($amt)=="" || trim($amt)<=0.00 || trim($amt)<=0){
                    $iserror++;
                  }

              }
            }

            if(count($amount)==$iserror){
              echo json_encode(['status'=>'error','data'=>'','msg'=>'Please enter amount','total'=>'0','id'=>'0']);
              exit;
            }

            $k=0;
            if(!empty($invoices)){
              foreach($invoices as $iid){
                  $invoice = Invoice::find($iid);
                  $tempinv = Invoice::where(['id'=>$iid])->first();
                    $bal=0;
                  if(!empty($tempinv)){
                    $bal=$tempinv['balance'];
                  }
                  $invoice->balance = $amount[$k]+$bal;
                  $invoice->save();  
                 


                  $form = new InvoicePayment;
                  $form->note           =  $note[$k];
                  $form->user_id        =  Auth::user()->id;
                  $form->payment_amount =  $amount[$k];
                  $form->payment_date   =  $payment_date[$k];
                  $form->created_at     =  date("Y-m-d H:i:s");
                  $form->updated_at     =  date("Y-m-d H:i:s");
                  $form->invoice_id     =  $iid;
                  $form->save();

                   $k++;
              }
            }
              

        echo json_encode(['status'=>'succ','data'=>'','msg'=>'Payment has been update successfully']);

    }

    /*Delete the users.*/
    public function remove_invoice_payment(Request $r){
      $payment_detail   = InvoicePayment::where(['id'=>$r->row_id])->first();
      $invoice          = Invoice::find($payment_detail->invoice_id);
      $invoice->balance = ($invoice->balance-$payment_detail->payment_amount);
      $invoice->save();
      InvoicePayment::where(['id'=>$r->row_id])->delete();
      echo json_encode(['status'=>'succ','msg'=>'Record Deleted Successfully','total'=>number_format((float)$invoice->balance, 2, '.', ''),'id'=>$payment_detail->invoice_id]);
    }

    /*Delete the invoice record from invoices table.*/
    public function delete(Request $r){
      Invoice::whereIn('id', explode(",",$r->id))->delete();
      InvoiceItem::whereIn('invoice_id', explode(",",$r->id))->delete();
      InvoicePayment::whereIn('invoice_id', explode(",",$r->id))->delete();
      echo json_encode(['status'=>'succ','msg'=>'Record Deleted Successfully']);
    }

    private function getMerchantName($id){
         return DB::table('customers')->where('qb_id', $id)->value('display_name');
    }


    public function ajax_save_invoice(Request $r){
          //dd($r);         
          $usertype = $r->usertype;
          $inv_items=$r->inv_items;

          if($inv_items[0]=="" || (int)$inv_items[0] == 0){
            echo json_encode(array('status'=>'error','msg'=>'Please add an item to the invoice first','invoice_id'=>'0'));
            exit;
          }

          $isEdit = !empty($r->edit_inv_id);
          
          $usertype = $r->usertype;
          $merchandid = $r->merchandid;

          if ($isEdit) {
            $invoice = Invoice::findOrFail($r->edit_inv_id);
        } else {
            $invoice = new Invoice();
            $invoice->merchant = $merchandid;
            $invoice->usertype = $usertype;
            $invoice->merchant_name = $this->getMerchantName($merchandid);
            $invoice->status = 'Pending';
            $invoice->type = 1;
        }
        
          $invoice->address = nl2br($r->address);
          $invoice->invoicedate = $r->invoicedate;
          $invoice->duedate = $r->duedate;
  
          $invoice->save();

      if($invoice){     
         // Save invoice items
        InvoiceItem::where('invoice_id', $invoice->id)->delete();
        $total = $this->storeInvoiceItems($invoice->id, $r);

        // Update total and invoice_id format
        $invoice->amount = $total;
        $invoice->invoice_id = '10' . $invoice->id;
        $invoice->save();

        $this->storeInvoiceLogs();
        return response()->json([
          'status' => 'succ',
          'msg' => $isEdit ? 'Invoice updated successfully' : 'Invoice created successfully',
          'invoice_id' => $invoice->id,
      ]);

             
          } else {
              echo json_encode(array('status'=>'error','msg'=>'Something wrong. Please try again.','invoice_id'=>'0'));
          }

    }

  private function storeInvoiceItems($invoiceId, Request $r){
    $total = 0;
    $invItems = $r->inv_items;
    $qty = $r->invqty;
    $rate = $r->invrate;
    $desc = $r->invdescription ?? [];
    $included = [];

    foreach ($invItems as $i => $itemId) {
        if (empty($itemId) || empty($qty[$i])) continue;

        $j = isset($included[$itemId]) ? $included[$itemId] + 1 : 0;
        $included[$itemId] = $j;

        $item = new InvoiceItem();
        $item->invoice_id = $invoiceId;
        $item->inv_item_id = $itemId;
        $item->description = $desc[$i] ?? '';
        $item->quantity = $qty[$i];
        $item->amount = $rate[$i];
        $item->start_date = $r->input("start_date_{$itemId}.{$j}", null);
        $item->end_date = $r->input("end_date_{$itemId}.{$j}", null);

        $item->save();

        $total += $qty[$i] * $rate[$i];
    }
    return $total;
  }

  public function merchantinvoice(Request $r){
      $mid = $r->mid;

      $invoices  = Invoice::where('merchant',$mid)->where('type','1')->orderBy('id', 'desc')->get();

      return view('invoices.merchantinvoice', compact('invoices'))->render();
  }


        function getaddress(Request $r){
          return $this->addressdetails($r->get('id'),$r->get('alt'));
        }

        private function addressdetails($id,$alt) 
        {
          $addressRow = DB::table('customers')->where('qb_id', $id)->first();
    $firstDecode = json_decode($addressRow->billing_address);

    if (is_string($firstDecode)) {
        // Second decode needed
        $address = json_decode($firstDecode);
    } else {
        // If already decoded to object
        $address = $firstDecode;
    }

    $billingAddress = collect([
        $address->Line1 ?? '',
        $address->Line2 ?? '',
        $address->Line3 ?? '',
        $address->Line4 ?? '',
        $address->Line5 ?? '',
        $address->City ?? '',
        $address->CountrySubDivisionCode ?? '',
        $address->PostalCode ?? '',
    ])->filter()->implode(', ');
    return  $billingAddress;           
        }

    public function invoicedetail(Request $r){
        $id=$r->id;
        $popup_title  = 'Invoice Detail';
        $invoice  = Invoice::where('id',"=",$id)->first();
        $user = User::select('*')->where('id',"=",Auth::user()->id)->first();
          $userinfo = array();
        $payments     = InvoiceItem::where(['invoice_id'=>$id])->get();
        $report_name  = 'invoice-report '.date('F d, Y').".pdf";
        $pdf_attachment = PDF::loadView('invoices.invoicedetail2',[
                'invoice' => $invoice,
                'popup_title'=>$popup_title,
                'payments'=>$payments,
                'user' =>$user,
                'pdf'=>'1',
            ])->setPaper('a4', 'portrait')->setOption('footer-html', view('invoices.footer')->render())->setOption('margin-bottom', 20); // ✅ Ensure there's space for the footer
        ;
        return $pdf_attachment->stream($report_name);
    }

public function getinvoice(Request $r){
    $id= $r->invoiceid;
    $invoice=Invoice::where('id',"=",$id)->first();
    $items=InvoiceItem::where('invoice_id',"=",$id)->get()->toArray();   

    foreach($items as $key=>$value){
      $start_date = $items[$key]['start_date'];
      $end_date = $items[$key]['end_date'];
      $items[$key]['start_date'] = substr($start_date,0,10);
      $items[$key]['end_date'] = substr($end_date,0,10);
    }            
    //get address details of agent or merchant that is selected
    $addressdetail = $this->addressdetails($invoice->merchant,$invoice->usertype);

    $data['invoice']=$invoice;
    $data['invoice']['address']=$addressdetail;
    $data['items']=$items;
    $data['mname']=$invoice->merchant_name;                       
    echo json_encode(['status'=>'succ','data'=>$data]);   
}

  public function storeInvoiceLogs()
  {
    $activity = Activity::all()->last();
   //dd($activity);
    if(isset($activity->id)){    
      $log_id = $activity->id;
      $userId = $activity->causer_id;
      $invoiceId = $activity->subject_id;
      $changes = $activity->changes;
      $newValues = $changes['attributes'];
      $type = $activity->description;
      if ($type == 'updated') {
        $oldValues = $changes['old'];
      }

      foreach ($newValues as $field => $newVal) {
        $log = new InvoiceLog;
        $log->invoice_id = $invoiceId;
        $log->log_id = $log_id;
        $log->field = $field;
        $log->new_value = $newVal;
        $log->type = $type;
        if ($type == 'updated') {
          $log->old_value = $oldValues[$field];
        }
        $log->user = $userId;
        $log->save();

        //delete activity log
        DB::delete('DELETE FROM activity_log where id = ?', [$log_id]);
      }
    // dd($changes);
    }
  }

  // get invoice logs/history
  public function invoice_history(Request $r, $id){
    $invoiceId = $id;
    $invoiceLogs = InvoiceLog::where('invoice_id',"=",$invoiceId)->orderBy('created_at', 'DESC')->get()->toArray();
    foreach($invoiceLogs as $key=>$value){  
      $created_date = $invoiceLogs[$key]['created_at'];
      $updated_date = $invoiceLogs[$key]['updated_at'];
      $invoiceLogs[$key]['created_at'] = convert_utc_to_user_time('Y-m-d H:i:s','m/d/Y H:i:s',$created_date);
      $invoiceLogs[$key]['updated_at'] = convert_utc_to_user_time('Y-m-d H:i:s','m/d/Y H:i:s',$updated_date);;
    }
    return $invoiceLogs;
  }
  
  public function send_mailer($html_msg,$emails,$subject,$attachment){
    $host         = 'smtp.gmail.com';
    $username     = 'noreply@quickbook.com';
    $Password     = 'faqq zfdm dbmb cjcm';

    try{
      
    $mail = new PHPMailer;
    $mail->isSMTP();
    $mail->SMTPDebug = 0;
    $mail->Host = $host;
    $mail->SMTPSecure = "tls";
    $mail->Port = 587;
    $mail->SMTPAuth = true;
    $mail->Username = $username;
    $mail->Password = $Password;
    $mail->setFrom('noreply@quickbook.com', 'CB Stream Live');
    $mail->Subject = $subject;
    $mail->Body = $html_msg;
    $mail->isHTML(true);      
    $mail->MsgHTML($html_msg);
    //add attachment
    if($attachment!=""){
      $mail->addAttachment($attachment);
    }
    foreach($emails as $email){
      $mail->addAddress($email , 'CB Stream Live');
    }    
     $mail->send();
    return true;
   } catch(phpmailerException $e){
     \Log::info("Email Not Send For ".$subject.":".implode(',',$emails));
     return false;
   }catch(Exception $e){
      \Log::info("Email Not Send For ".$subject.":".implode(',',$emails));
      return false;
   }
  }
}
