<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use Illuminate\Support\Facades\Session;
use Mail;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(){
       // $this->middleware('auth');
        // Manually checking authentication since $this->middleware() does not work
        if (!Auth::check()) {
          abort(403, 'Unauthorized');
      }
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
      $page_title ='Update Profile';
      $profileInfo = User::find(Auth::user()->id);
      if($profileInfo->timezone ==  ""){
        $profileInfo->timezone  = 'UTC';
      }
      $tzlist = timezones_list();
      return view('accounts.profile',compact('page_title','tzlist','profileInfo'));
    }

    public function home(){
        if(auth()->user()->role=='1'){
          $home_url = 'invoices';
        } else if(auth()->user()->role=='2'){
          $home_url   = 'reports/transaction-report';
        } else if(auth()->user()->role=='3'){
          $home_url = 'reports/merchant-report';
        } else if(auth()->user()->role=='4'){
          $home_url = 'reports/agent-report';
        } else {
          $home_url = 'users/profile';
        }
        return redirect($home_url);
    }

}
