<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
class DashboardController extends Controller
{
  public function __construct(){
      $this->middleware('auth');
  }

    public function index(){
        $page_title ='Dashboard';
        return view('dashboard.index',compact('page_title'));
    }

    public function tableList(){
        $page_title ='Dashboard';
        return view('dashboard.table',compact('page_title'));
    }

    public function ajaxtableList(Request $r){
        $users  = DB::table('users');
        $total_records  = $users->count();
        $data = $users->select('id','remember_token','name','email')->offset($r->start)->limit($r->length)->get();
        echo json_encode([
          "data"=>$data,
          "draw"=> $r->draw,
          "recordsFiltered"=> $total_records,
          "recordsTotal"=> $total_records
        ]
        );
    }



}
