<?php
namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller; // Ensure this is included
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Carbon\Carbon;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
   // protected $redirectTo = RouteServiceProvider::HOME;
    protected $redirectTo = '/dashboard';  // Change this to your desired path

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
//RbCbStrm@1
    public function authenticated(){
        if(auth()->user()->role=='admin'){
             return redirect('/users');
         } else if(auth()->user()->role=='user'){
             return redirect('/reports/transaction-report');
         } else if(auth()->user()->role=='agent'){
             return redirect('/users');
         } else if(auth()->user()->role=='merchant'){
             return redirect('/reports/merchant-report');
         }
        return redirect('/dashboard');
    }

    public function gateway_login(Request $req){
      $page_title = 'Gateway Login';
      return view('auth.login2',compact('page_title'));
    }

    public function login_merchant(Request $req){
      $page_title = 'Gateway Login';
      $link  = 'https://secure.nmi.com/merchants/login.php';
      return view('auth.login3',compact('page_title','link'));
    }

    public function login_gateway(Request $req){
      $page_title = 'Gateway Login';
      $link  = 'https://secure.nmi.com/resellers/login.php';
      return view('auth.login3',compact('page_title','link'));
    }


    public function login2(Request $req){
      $email  = $req->email;
      $password = $req->password;
      $checkUser = DB::table('users as U');
      $checkUser->select('U.*');
       $checkUser->where(function($query) use ($email,$password){
           $query->where(function($query) use ($email,$password){
               $query->where(['U.email' => $email,'U.password' => md5($password)]);
           });
       });
       $countUser = $checkUser->first();
      if($countUser){
        if($countUser->status=='Active'){
          $user = \App\User::where([
              'id' => $countUser->id,
          ])->first();
          Session::put('user_timezone', $user->timezone);
          Session::put('group_id', $user->role);
          Session::put('list_inactive_merchants', ['Active']);
          Session::put('list_inactive_agents', ['Active']);

          /*Manage the permissions.*/
          if($user->id==1){
            $permission_lists = DB::table('permissions')->get();
            $permission_lists_arr = array();
            foreach($permission_lists as $permission_list){
              $permission_lists_arr[] = $permission_list->route_name;
              $permission_lists_arr[] = $permission_list->modify_route;
              $permission_lists_arr[] = $permission_list->view_route;
              $permission_lists_arr[] = $permission_list->delete_route;
            }
            $permissions = $permission_lists_arr;
          } else {
            $group_permissions = DB::table('roles')->where(['id'=>$user->role])->first();
            if($group_permissions->permissions==""){
              $group_permissions->permissions = json_encode(array());
            }
            $permissions = json_decode($group_permissions->permissions,true);
          }
          array_push($permissions,'logout');
          array_push($permissions,'agents/ignore_downloaded_merchants');
          array_push($permissions,'page_403');
          Session::put('permissions', $permissions);
          /*End*/
          Auth::login($user);
            return redirect('/invoices');
        } else {
          return redirect()->back()->withErrors(['error' => 'Your account is Inactive','email'=>$req->email]);
        }
      } else {
        return redirect()->back()->withErrors(['error' => 'These credentials do not match our records.','email'=>$req->email]);
    }
  }

}
