<?php
namespace App\Http\Controllers\Auth;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Send;
use Mail;
use View;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
class ForgotPasswordController extends Controller
{
  public function reset_password_form($token=null){
    $email  = '';
    $token_set  = 0;
    $token_count  = 0;
    if($token!=null){
      $token_set  = 1;
      $token_detail = DB::table('password_resets')->where(['token'=>$token]);
      if($token_detail->count()>0){
        $token_count  = 1;
        $email  = $token_detail->first()->email;
      } else {
        $token_count  = 0;
      }
    }
    return view('auth.reset-password',compact('email','token','token_count','token_set'));
  }

  public function reset(){
    return view('auth.passwords.email');
  }

  /*Generate new password.*/
  public function generate_password(){
    echo json_encode(['msg'=>'succ','pass'=>generateStrongPassword(8)]);
  }

  public function reset_password(Request $r){

    $checkUser = DB::table('users as U');
    $checkUser->select('U.*');
    $checkUser->where(['U.email' => $r->email]);
    $countUser = $checkUser->first();
    if($countUser){
      $email  = $countUser->email;
      $r->merge([
        'email' => $email,
      ]);
    } else {
      $email  = $r->email;
    }
    if($r->token_set==0){
      $rules = [
          'email' => 'required|exists:users,email',
     ];
     $customMessages = [
          'email.exists'=>'The email address entered cannot be found in our records.',
      ];
      $r->validate($rules,$customMessages); 

      /*This is for send email.*/
      $token  = md5(time());
      $user_detail = DB::table('password_resets')->where(['email'=>$email]);
      if($user_detail->count()>0){
        DB::table('password_resets')->where(['email'=>$email])->delete();
      }
      DB::table('password_resets')->insert(['email'=>$email,'token'=>$token]);
      $link = url('/reset-password')."/".$token;
      $view = View::make('emails.email_reset_password', [
            'link' => $link,
        ]);
      $html = $view->render();
      $message          =  array();
      $data             =  array();
      $data_all = array('temp_data'=>$html,'email_id'=>$email,'subject'=>'Reset Password Notification');
      try{
        Mail::send(array(), $data, function($message) use ($data_all){
            $message->to($data_all['email_id']);
            $message->subject($data_all['subject']);
            $message->from('noreply@quickbook.com');
            $message->setBody($data_all['temp_data'], 'text/html');
        });
      } catch (\Exception $ex) {
        echo 'coming in catch';
      }
      echo json_encode(array('status'=>'succ','msg'=>'Your Reset password link has been sent to your email address.So please check your email.'));
    } else {
      $this->validate_reset_password($r);
      $reset_verify  = DB::table('password_resets')->where(['email'=>$email,'token'=>$r->token_value]);
      if($reset_verify->count()>0){
        $reset_verify->delete();
        $changePass = \App\User::where(['email'=>$r->email])->update(['password'=>md5($r->new_password)]);
        if($changePass){
          echo json_encode(array('status'=>'succ','msg'=>'Your password reset successfully.'));
        }
      } else {
        echo json_encode(array('status'=>'error','msg'=>'Your token is not valid for this email address.'));
      }
    }
    exit;
    // $r->merge([
    //   'password' => md5($r->password),
    // ]);
  }

  public function validate_reset_password($req){
    $rules = [
        'email' => 'required|exists:users,email',
   ];
    $rules['new_password'] = 'required|string|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9]).{8,}$/';
    $rules['retype_password'] = 'required|same:new_password';
    $customMessages = [
         'email.exists'=>'The entered email is invalid.',
         'new_password.regex' => 'Password Should have At least 8 char long,One Uppercase letter,One Lower case letter And One numeric letter.',
     ];
     $r->validate($rules,$customMessages);
  }


    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;
}
